/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.python;

import fr.greencodeinitiative.python.checks.AvoidDoubleQuoteCheck;
import fr.greencodeinitiative.python.checks.AvoidFullSQLRequest;
import fr.greencodeinitiative.python.checks.AvoidGettersAndSetters;
import fr.greencodeinitiative.python.checks.AvoidGlobalVariableInFunctionCheck;
import fr.greencodeinitiative.python.checks.AvoidListComprehensionInIterations;
import fr.greencodeinitiative.python.checks.AvoidSQLRequestInLoop;
import fr.greencodeinitiative.python.checks.AvoidTryCatchFinallyCheck;
import fr.greencodeinitiative.python.checks.AvoidUnoptimizedVectorImagesCheck;
import fr.greencodeinitiative.python.checks.DetectUnoptimizedImageFormat;
import fr.greencodeinitiative.python.checks.NoFunctionCallWhenDeclaringForLoop;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.plugins.python.api.PythonCustomRuleRepository;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;

public class PythonRuleRepository
implements RulesDefinition,
PythonCustomRuleRepository {
    public static final String LANGUAGE = "py";
    public static final String NAME = "ecoCode";
    public static final String RESOURCE_BASE_PATH = "io/ecocode/rules/python";
    public static final String REPOSITORY_KEY = "ecocode-python";
    private final SonarRuntime sonarRuntime;

    public PythonRuleRepository(SonarRuntime sonarRuntime) {
        this.sonarRuntime = sonarRuntime;
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository(REPOSITORY_KEY, LANGUAGE).setName(NAME);
        RuleMetadataLoader ruleMetadataLoader = new RuleMetadataLoader(RESOURCE_BASE_PATH, this.sonarRuntime);
        ruleMetadataLoader.addRulesByAnnotatedClass(repository, this.checkClasses());
        repository.done();
    }

    public String repositoryKey() {
        return REPOSITORY_KEY;
    }

    public List<Class> checkClasses() {
        return Arrays.asList(AvoidDoubleQuoteCheck.class, AvoidGettersAndSetters.class, AvoidGlobalVariableInFunctionCheck.class, AvoidSQLRequestInLoop.class, AvoidTryCatchFinallyCheck.class, AvoidUnoptimizedVectorImagesCheck.class, NoFunctionCallWhenDeclaringForLoop.class, AvoidFullSQLRequest.class, AvoidListComprehensionInIterations.class, DetectUnoptimizedImageFormat.class);
    }
}

