/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.python.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.AssertStatement;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.AwaitExpression;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.ComprehensionIf;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.ExecStatement;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FinallyClause;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.PrintStatement;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.ReprExpression;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.SetLiteral;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.tree.TupleParameter;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC4")
@DeprecatedRuleKey(repositoryKey="gci-python", ruleKey="D4")
public class AvoidGlobalVariableInFunctionCheck
extends PythonSubscriptionCheck {
    public static final String DESCRIPTION = "Use local variable (function/class scope) instead of global variable (application scope)";
    private List<String> globalVariables;
    private List<String> definedLocalVariables;
    private Map<Tree, String> usedLocalVariables;

    public void initialize(SubscriptionCheck.Context context) {
        this.globalVariables = new ArrayList<String>();
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::visitFileInput);
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, this::visitFuncDef);
    }

    public void visitFileInput(SubscriptionContext ctx) {
        FileInput fileInput = (FileInput)ctx.syntaxNode();
        fileInput.globalVariables().stream().filter(v -> v.is(new Symbol.Kind[]{Symbol.Kind.OTHER})).forEach(v -> this.globalVariables.add(v.name()));
    }

    void visitFuncDef(SubscriptionContext ctx) {
        this.definedLocalVariables = new ArrayList<String>();
        this.usedLocalVariables = new HashMap<Tree, String>();
        FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
        ParameterList parameterList = functionDef.parameters();
        if (parameterList != null) {
            parameterList.nonTuple().forEach(p -> this.extractVariablesFromExpression((Tree)p, true));
        }
        functionDef.body().statements().forEach(s -> this.extractVariablesFromExpression((Tree)s, false));
        this.usedLocalVariables.entrySet().stream().filter(e -> !this.definedLocalVariables.contains(e.getValue()) && this.globalVariables.contains(e.getValue())).forEach(e -> ctx.addIssue((Tree)e.getKey(), DESCRIPTION));
    }

    void extractVariablesFromExpression(Tree element, boolean isAssigned) {
        if (element == null) {
            return;
        }
        switch (element.getKind()) {
            case REGULAR_ARGUMENT: {
                this.extractVariablesFromExpression((Tree)((RegularArgument)element).expression(), isAssigned);
                break;
            }
            case ARG_LIST: {
                ((ArgList)element).arguments().forEach(a -> this.extractVariablesFromExpression((Tree)a, isAssigned));
                break;
            }
            case ANNOTATED_ASSIGNMENT: {
                AnnotatedAssignment annotatedAssignment = (AnnotatedAssignment)element;
                this.extractVariablesFromExpression((Tree)annotatedAssignment.variable(), true);
                this.extractVariablesFromExpression((Tree)annotatedAssignment.assignedValue(), false);
                break;
            }
            case ASSERT_STMT: {
                AssertStatement assertStatement = (AssertStatement)element;
                this.extractVariablesFromExpression((Tree)assertStatement.condition(), false);
                this.extractVariablesFromExpression((Tree)assertStatement.message(), false);
                break;
            }
            case ASSIGNMENT_STMT: {
                AssignmentStatement assignmentStatement = (AssignmentStatement)element;
                assignmentStatement.lhsExpressions().forEach(e -> this.extractVariablesFromExpression((Tree)e, true));
                this.extractVariablesFromExpression((Tree)assignmentStatement.assignedValue(), false);
                break;
            }
            case CALL_EXPR: {
                this.extractVariablesFromExpression((Tree)((CallExpression)element).argumentList(), isAssigned);
                break;
            }
            case CONDITIONAL_EXPR: {
                ConditionalExpression conditionalExpression = (ConditionalExpression)element;
                this.extractVariablesFromExpression((Tree)conditionalExpression.trueExpression(), isAssigned);
                this.extractVariablesFromExpression((Tree)conditionalExpression.falseExpression(), false);
                this.extractVariablesFromExpression((Tree)conditionalExpression.condition(), isAssigned);
                break;
            }
            case COMPOUND_ASSIGNMENT: {
                CompoundAssignmentStatement compoundAssignmentStatement = (CompoundAssignmentStatement)element;
                this.extractVariablesFromExpression((Tree)compoundAssignmentStatement.lhsExpression(), true);
                this.extractVariablesFromExpression((Tree)compoundAssignmentStatement.rhsExpression(), false);
                break;
            }
            case DICTIONARY_LITERAL: {
                ((DictionaryLiteral)element).elements().forEach(e -> this.extractVariablesFromExpression((Tree)e, false));
                break;
            }
            case ELSE_CLAUSE: {
                this.extractVariablesFromExpression((Tree)((ElseClause)element).body(), isAssigned);
                break;
            }
            case EXCEPT_CLAUSE: {
                this.extractVariablesFromExpression((Tree)((ExceptClause)element).body(), isAssigned);
                break;
            }
            case EXEC_STMT: {
                ExecStatement execStatement = (ExecStatement)element;
                this.extractVariablesFromExpression((Tree)execStatement.expression(), isAssigned);
                this.extractVariablesFromExpression((Tree)execStatement.globalsExpression(), isAssigned);
                this.extractVariablesFromExpression((Tree)execStatement.localsExpression(), isAssigned);
                break;
            }
            case EXPRESSION_LIST: {
                ((ExpressionList)element).expressions().forEach(e -> this.extractVariablesFromExpression((Tree)e, isAssigned));
                break;
            }
            case EXPRESSION_STMT: {
                ((ExpressionStatement)element).expressions().forEach(e -> this.extractVariablesFromExpression((Tree)e, isAssigned));
                break;
            }
            case FILE_INPUT: {
                this.extractVariablesFromExpression((Tree)((FileInput)element).statements(), isAssigned);
                break;
            }
            case FINALLY_CLAUSE: {
                this.extractVariablesFromExpression((Tree)((FinallyClause)element).body(), isAssigned);
                break;
            }
            case FOR_STMT: {
                ForStatement forStatement = (ForStatement)element;
                forStatement.expressions().forEach(e -> this.extractVariablesFromExpression((Tree)e, true));
                forStatement.testExpressions().forEach(e -> this.extractVariablesFromExpression((Tree)e, false));
                this.extractVariablesFromExpression((Tree)forStatement.body(), isAssigned);
                this.extractVariablesFromExpression((Tree)forStatement.elseClause(), isAssigned);
                break;
            }
            case IF_STMT: {
                IfStatement ifStatement = (IfStatement)element;
                this.extractVariablesFromExpression((Tree)ifStatement.condition(), false);
                this.extractVariablesFromExpression((Tree)ifStatement.body(), isAssigned);
                this.extractVariablesFromExpression((Tree)ifStatement.elseBranch(), isAssigned);
                ifStatement.elifBranches().forEach(b -> this.extractVariablesFromExpression((Tree)b, isAssigned));
                break;
            }
            case LAMBDA: {
                this.extractVariablesFromExpression((Tree)((LambdaExpression)element).expression(), isAssigned);
                break;
            }
            case LIST_LITERAL: {
                this.extractVariablesFromExpression((Tree)((ListLiteral)element).elements(), false);
                break;
            }
            case NAME: {
                if (isAssigned) {
                    this.definedLocalVariables.add(((Name)element).name());
                    break;
                }
                this.usedLocalVariables.put(element, ((Name)element).name());
                break;
            }
            case PRINT_STMT: {
                ((PrintStatement)element).expressions().forEach(e -> this.extractVariablesFromExpression((Tree)e, false));
                break;
            }
            case RAISE_STMT: {
                RaiseStatement raiseStatement = (RaiseStatement)element;
                this.extractVariablesFromExpression((Tree)raiseStatement.fromExpression(), false);
                raiseStatement.expressions().forEach(e -> this.extractVariablesFromExpression((Tree)e, false));
                break;
            }
            case REPR: {
                this.extractVariablesFromExpression((Tree)((ReprExpression)element).expressionList(), isAssigned);
                break;
            }
            case RETURN_STMT: {
                ((ReturnStatement)element).expressions().forEach(e -> this.extractVariablesFromExpression((Tree)e, false));
                break;
            }
            case SET_LITERAL: {
                ((SetLiteral)element).elements().forEach(e -> this.extractVariablesFromExpression((Tree)e, false));
                break;
            }
            case STATEMENT_LIST: {
                ((StatementList)element).statements().forEach(s -> this.extractVariablesFromExpression((Tree)s, isAssigned));
                break;
            }
            case TRY_STMT: {
                TryStatement tryStatement = (TryStatement)element;
                this.extractVariablesFromExpression((Tree)tryStatement.body(), isAssigned);
                tryStatement.exceptClauses().forEach(c -> this.extractVariablesFromExpression((Tree)c, isAssigned));
                this.extractVariablesFromExpression((Tree)tryStatement.elseClause(), isAssigned);
                this.extractVariablesFromExpression((Tree)tryStatement.finallyClause(), isAssigned);
                break;
            }
            case PARAMETER: {
                Parameter parameter = (Parameter)element;
                this.extractVariablesFromExpression((Tree)parameter.name(), true);
                this.extractVariablesFromExpression((Tree)parameter.defaultValue(), false);
                break;
            }
            case TUPLE_PARAMETER: {
                ((TupleParameter)element).parameters().forEach(p -> this.extractVariablesFromExpression((Tree)p, isAssigned));
                break;
            }
            case PARAMETER_LIST: {
                ((ParameterList)element).all().forEach(a -> this.extractVariablesFromExpression((Tree)a, true));
                break;
            }
            case WHILE_STMT: {
                WhileStatement whileStatement = (WhileStatement)element;
                this.extractVariablesFromExpression((Tree)whileStatement.condition(), false);
                this.extractVariablesFromExpression((Tree)whileStatement.body(), isAssigned);
                this.extractVariablesFromExpression((Tree)whileStatement.elseClause(), isAssigned);
                break;
            }
            case YIELD_EXPR: {
                ((YieldExpression)element).expressions().forEach(e -> this.extractVariablesFromExpression((Tree)e, isAssigned));
                break;
            }
            case YIELD_STMT: {
                this.extractVariablesFromExpression((Tree)((YieldStatement)element).yieldExpression(), isAssigned);
                break;
            }
            case PARENTHESIZED: {
                this.extractVariablesFromExpression((Tree)((ParenthesizedExpression)element).expression(), isAssigned);
                break;
            }
            case UNPACKING_EXPR: {
                this.extractVariablesFromExpression((Tree)((UnpackingExpression)element).expression(), isAssigned);
                break;
            }
            case AWAIT: {
                this.extractVariablesFromExpression((Tree)((AwaitExpression)element).expression(), false);
                break;
            }
            case TUPLE: {
                ((Tuple)element).elements().forEach(e -> this.extractVariablesFromExpression((Tree)e, isAssigned));
                break;
            }
            case DICT_COMPREHENSION: {
                this.extractVariablesFromExpression((Tree)((DictCompExpression)element).comprehensionFor(), false);
                break;
            }
            case LIST_COMPREHENSION: 
            case SET_COMPREHENSION: 
            case GENERATOR_EXPR: {
                this.extractVariablesFromExpression((Tree)((ComprehensionExpression)element).resultExpression(), false);
                this.extractVariablesFromExpression((Tree)((ComprehensionExpression)element).comprehensionFor(), true);
                break;
            }
            case COMP_FOR: {
                this.extractVariablesFromExpression((Tree)((ComprehensionFor)element).loopExpression(), true);
                this.extractVariablesFromExpression((Tree)((ComprehensionFor)element).iterable(), false);
                break;
            }
            case COMP_IF: {
                this.extractVariablesFromExpression((Tree)((ComprehensionIf)element).condition(), false);
                break;
            }
            case SUBSCRIPTION: {
                this.extractVariablesFromExpression((Tree)((SubscriptionExpression)element).object(), false);
                this.extractVariablesFromExpression((Tree)((SubscriptionExpression)element).subscripts(), false);
                break;
            }
            case PLUS: 
            case MINUS: 
            case MULTIPLICATION: 
            case DIVISION: 
            case FLOOR_DIVISION: 
            case MODULO: 
            case MATRIX_MULTIPLICATION: 
            case SHIFT_EXPR: 
            case BITWISE_AND: 
            case BITWISE_OR: 
            case BITWISE_XOR: 
            case AND: 
            case OR: 
            case COMPARISON: 
            case POWER: {
                BinaryExpression binaryExpression = (BinaryExpression)element;
                this.extractVariablesFromExpression((Tree)binaryExpression.leftOperand(), false);
                this.extractVariablesFromExpression((Tree)binaryExpression.rightOperand(), false);
                break;
            }
            case UNARY_PLUS: 
            case UNARY_MINUS: 
            case BITWISE_COMPLEMENT: 
            case NOT: {
                this.extractVariablesFromExpression((Tree)((UnaryExpression)element).expression(), false);
                break;
            }
            case ASSIGNMENT_EXPRESSION: {
                AssignmentExpression assignmentExpression = (AssignmentExpression)element;
                this.extractVariablesFromExpression((Tree)assignmentExpression.lhsName(), true);
                this.extractVariablesFromExpression((Tree)assignmentExpression.expression(), false);
                break;
            }
            case KEY_VALUE_PAIR: {
                KeyValuePair keyValuePair = (KeyValuePair)element;
                this.extractVariablesFromExpression((Tree)keyValuePair.key(), true);
                this.extractVariablesFromExpression((Tree)keyValuePair.value(), false);
                break;
            }
        }
    }
}

