package io.github.andreyzebin.gitSql.git;

import io.github.zebin.javabash.process.TextTerminal;
import org.apache.commons.lang3.tuple.Pair;

import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public interface GitAuth {
    ConcurrentMap<Pair<TextTerminal, String>, String> sshPerTerminal = new ConcurrentHashMap<>();


    default boolean useAuthHeader() {
        return false;
    }

    default void beforeRemote(TextTerminal terminal) {
    }

    default void afterRemote(TextTerminal terminal) {
    }

    default String injectAuth(String origin) {
        return origin;
    }

    static GitAuth ofSshAgent(String key) {
        return new GitAuth() {
            @Override
            public void beforeRemote(TextTerminal terminal) {
                // init ssh agent once per terminal
                sshPerTerminal.computeIfAbsent(
                        Pair.of(terminal, key),
                        (k) -> {
                            terminal.eval("eval `ssh-agent`");
                            GitBindings.sshAgent(key, terminal);
                            return "";
                        }
                );
            }

        };
    }

    static GitAuth empty() {
        return new GitAuth() {
        };
    }

    // TODO move to json-bash TerminalSandBox
    static void openSecret(TextTerminal bash, String key, String value) {
        bash.eval(String.format("%s=%s", key, value), String.format("%s=***", key));
    }

    static GitAuth userAndToken(String username, String token) {
        return new GitAuth() {

            @Override
            public void beforeRemote(TextTerminal terminal) {
                openSecret(terminal, "GIT_USERNAME", username);
                openSecret(terminal, "GIT_TOKEN", token);
            }

            @Override
            public String injectAuth(String origin) {
                final URI uri = URI.create(origin);
                return URI.create(uri.getScheme() + "://" + "$GIT_USERNAME" + ":" + "$GIT_TOKEN" + "@"
                        + uri.getRawAuthority()
                        + uri.getRawPath()).toString();
            }
        };
    }

    static GitAuth ofApiToken(String token) {
        return new GitAuth() {
            @Override
            public boolean useAuthHeader() {
                return true;
            }

            @Override
            public void beforeRemote(TextTerminal terminal) {
                openSecret(terminal, "API_TOKEN", token);
            }
        };
    }
}
