/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.cache;

import io.github.andreyzebin.gitSql.cache.GitEventListener;
import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.AllFileManager;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class FileManagerCacheProxy
implements AllFileManager,
GitEventListener {
    private final AtomicReference<String> cacheControl;
    private final Map<String, FileManagerCache> caches;
    private final Map<String, FileReadCache> readCaches;
    private final Map<String, LsCache> lsCache;
    private PosixPath cur;
    private final AllFileManager fm;

    public static FileManagerCacheProxy cachedProxy(AllFileManager delegate, AtomicReference<String> cacheControl) {
        HashMap<String, FileManagerCache> fmCache = new HashMap<String, FileManagerCache>();
        HashMap<String, FileReadCache> readCaches = new HashMap<String, FileReadCache>();
        HashMap<String, LsCache> lsCache = new HashMap<String, LsCache>();
        return new FileManagerCacheProxy(delegate, cacheControl, fmCache, readCaches, lsCache);
    }

    @Override
    public void call(String event) {
        if (event.equals("clear")) {
            this.readCaches.remove(this.cacheControl.get());
            this.caches.remove(this.cacheControl.get());
            this.lsCache.remove(this.cacheControl.get());
        }
    }

    public TextTerminal getTerminal() {
        return this.fm.getTerminal();
    }

    public FileManagerCacheProxy(AllFileManager delegate, AtomicReference<String> cacheControl, Map<String, FileManagerCache> caches, Map<String, FileReadCache> readCaches, Map<String, LsCache> lsCache) {
        this.cacheControl = cacheControl;
        this.caches = caches;
        this.readCaches = readCaches;
        this.lsCache = lsCache;
        this.fm = delegate;
    }

    private void dropDir(PosixPath d) {
        this.getDirsCache().remove(d);
    }

    private void dropFile(PosixPath d) {
        this.getReadCache().remove(d);
        this.getFilesCache().remove(d);
    }

    private Map<PosixPath, Boolean> getDirsCache() {
        return this.getCache().dirs;
    }

    private Map<PosixPath, Boolean> getFilesCache() {
        return this.getCache().files;
    }

    private FileManagerCache getCache() {
        if (this.cacheControl.get() == null) {
            return new FileManagerCache();
        }
        return this.caches.computeIfAbsent(this.cacheControl.get(), h -> new FileManagerCache());
    }

    private Map<PosixPath, String> getReadCache() {
        if (this.cacheControl.get() == null) {
            return new FileReadCache().files;
        }
        return this.readCaches.computeIfAbsent((String)this.cacheControl.get(), (Function<String, FileReadCache>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getReadCache$1(java.lang.String ), (Ljava/lang/String;)Lio/github/andreyzebin/gitSql/cache/FileManagerCacheProxy$FileReadCache;)()).files;
    }

    private Map<PosixPath, List<PosixPath>> getLsCache() {
        if (this.cacheControl.get() == null) {
            return new LsCache().files;
        }
        return this.lsCache.computeIfAbsent((String)this.cacheControl.get(), (Function<String, LsCache>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getLsCache$2(java.lang.String ), (Ljava/lang/String;)Lio/github/andreyzebin/gitSql/cache/FileManagerCacheProxy$LsCache;)()).files;
    }

    public String read(PosixPath pp) {
        return this.getReadCache().computeIfAbsent(this.getAbs(pp), p -> this.fm.read(pp));
    }

    public List<PosixPath> list() {
        return List.of();
    }

    public PosixPath getCurrent() {
        if (this.cur == null) {
            this.cur = this.fm.getCurrent();
            return this.cur;
        }
        return this.cur;
    }

    public PosixPath goUp() {
        return this.fm.goUp();
    }

    public PosixPath go(PosixPath path) {
        if (path.equals((Object)this.cur)) {
            return path;
        }
        this.cur = this.fm.go(path);
        return this.cur;
    }

    public PosixPath makeDir(PosixPath newDir) {
        if (this.dirExists(newDir)) {
            return this.getAbs(newDir);
        }
        this.getAbs(newDir).streamDescending().forEach(this::dropDir);
        return this.fm.makeDir(newDir);
    }

    public PosixPath makeFile(PosixPath newDir) {
        this.dropFile(this.getAbs(newDir));
        return this.fm.makeFile(newDir);
    }

    public Writer write(PosixPath pp) {
        this.dropFile(this.getAbs(pp));
        return this.fm.write(pp);
    }

    public Writer append(PosixPath pp) {
        this.dropFile(this.getAbs(pp));
        return this.fm.append(pp);
    }

    public boolean removeFile(PosixPath file) {
        this.dropFile(this.getAbs(file));
        return this.fm.removeFile(file);
    }

    public boolean removeDir(PosixPath path) {
        this.getFilesCache().keySet().stream().filter(kk -> kk.startsWith(this.getAbs(path))).forEach(kk -> this.getFilesCache().remove(kk));
        this.getReadCache().keySet().stream().filter(kk -> kk.startsWith(this.getAbs(path))).forEach(kk -> this.getReadCache().remove(kk));
        this.getDirsCache().keySet().stream().filter(kk -> kk.startsWith(this.getAbs(path))).forEach(kk -> this.getDirsCache().remove(kk));
        return this.fm.removeDir(path);
    }

    public boolean dirExists(PosixPath newDir) {
        return this.getDirsCache().computeIfAbsent(this.getAbs(newDir), d -> this.fm.dirExists(newDir));
    }

    private PosixPath getAbs(PosixPath newDir) {
        return newDir.isAbsolute() ? newDir : this.getCurrent().climb(newDir);
    }

    public boolean fileExists(PosixPath newDir) {
        return this.getFilesCache().computeIfAbsent(this.getAbs(newDir), f -> this.fm.fileExists(newDir));
    }

    public List<PosixPath> list(PosixPath path) {
        return this.getLsCache().computeIfAbsent(this.getAbs(path), p -> this.fm.list(path));
    }

    private static /* synthetic */ LsCache lambda$getLsCache$2(String h) {
        return new LsCache();
    }

    private static /* synthetic */ FileReadCache lambda$getReadCache$1(String h) {
        return new FileReadCache();
    }

    public static class FileManagerCache {
        Map<PosixPath, Boolean> files = new HashMap<PosixPath, Boolean>();
        Map<PosixPath, Boolean> dirs = new HashMap<PosixPath, Boolean>();
    }

    public static class FileReadCache {
        Map<PosixPath, String> files = new HashMap<PosixPath, String>();
    }

    public static class LsCache {
        Map<PosixPath, List<PosixPath>> files = new HashMap<PosixPath, List<PosixPath>>();
    }
}

