/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.config.DirectoryTreeFactory;
import io.github.andreyzebin.gitSql.git.BranchHead;
import io.github.andreyzebin.gitSql.git.Change;
import io.github.andreyzebin.gitSql.git.Commit;
import io.github.andreyzebin.gitSql.git.GitBindings;
import io.github.andreyzebin.gitSql.git.GitFs;
import io.github.andreyzebin.gitSql.git.Versions;
import io.github.zebin.javabash.sandbox.AllFileManager;
import io.github.zebin.javabash.sandbox.BashUtils;
import io.github.zebin.javabash.sandbox.DirectoryTree;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements GitFs {
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    protected final AllFileManager fm;
    protected final StringBuffer stage = new StringBuffer();
    protected final DirectoryTreeFactory<DirectoryTree> dtFactory;
    protected final Map<String, DirectoryTree> dt = new HashMap<String, DirectoryTree>();

    protected AbstractClient(AllFileManager fm, DirectoryTreeFactory<DirectoryTree> dtFactory) {
        this.fm = fm;
        this.dtFactory = dtFactory;
    }

    @Override
    public Versions seek(String commit) {
        return this.setupDir(() -> {
            GitBindings.checkout(commit, this.fm.getTerminal());
            return this;
        });
    }

    @Override
    public void reset() {
        this.setupDir(() -> GitBindings.resetHard(this.fm.getTerminal()));
    }

    public Stream<Commit> listCommits() {
        return this.setupDir(() -> GitBindings.commitsList(this.fm.getTerminal()));
    }

    @Override
    public Stream<BranchHead> listBranches() {
        return this.setupDir(() -> GitBindings.getBranches(this.fm.getTerminal()));
    }

    @Override
    public boolean contains(String hash) {
        HashSet commits = new HashSet();
        this.listCommits().forEach(co -> {
            commits.add(co.getHash());
            commits.addAll(co.getParents());
        });
        return commits.contains(hash);
    }

    @Override
    public Stream<? extends Change> getChanges(String hashFrom) {
        return this.setupDir(() -> GitBindings.filesChangedQuery("", GitBindings.sinceHash(hashFrom), this.fm.getTerminal()));
    }

    @Override
    public Stream<? extends Change> getChanges(String hashFrom, String hashTo) {
        return this.setupDir(() -> GitBindings.filesChangedQuery("", GitBindings.periodHash(hashFrom, hashTo), this.fm.getTerminal()));
    }

    @Override
    public Instant getTimestamp() {
        return this.setupDir(() -> GitBindings.commitsList(this.fm.getTerminal()).findFirst().get().getTimestampInstant());
    }

    @Override
    public void pull() {
        this.setupDir(() -> GitBindings.pull(this.fm.getTerminal()));
    }

    @Override
    public void push() {
        this.setupDir(() -> GitBindings.push(this.fm.getTerminal()));
    }

    @Override
    public void setOrigin(String origin) {
        throw new RuntimeException("Unimplemented!");
    }

    @Override
    public Optional<String> getOrigin() {
        return this.setupDir(() -> GitBindings.getOrigin(this.fm.getTerminal()));
    }

    @Override
    public void fetch() {
        this.setupDir(() -> this.fm.getTerminal().eval(String.format("git fetch", new Object[0])));
    }

    @Override
    public void setUpstream(String localBranch, String upstream) {
        this.setupDir(() -> this.fm.getTerminal().eval(String.format("git branch -u  %s %s ", upstream, localBranch)));
    }

    @Override
    public Optional<String> getUpstream(String local) {
        throw new RuntimeException("Unimplemented!");
    }

    @Override
    public Optional<String> getBranch() {
        return this.setupDir(() -> GitBindings.getBranch(this.fm.getTerminal()));
    }

    @Override
    public void setBranch(String branchName) {
        this.setupDir(() -> this.fm.getTerminal().eval(String.format("git checkout %s ", branchName)));
    }

    @Override
    public void merge(String hash) {
        this.setupDir(() -> this.fm.getTerminal().eval(String.format("git merge %s ", hash)));
    }

    @Override
    public void commit() {
        if (!this.stage.toString().isBlank()) {
            this.setupDir(() -> {
                Arrays.stream(this.stage.toString().split(System.lineSeparator())).forEach(cFile -> GitBindings.add(this.fm.getTerminal(), Path.of(cFile, new String[0])));
                if (GitBindings.hasStatus(this.fm.getTerminal())) {
                    GitBindings.commit(this.fm.getTerminal());
                } else {
                    log.debug("Status has no changes, skip commit.");
                }
            });
        }
        this.stage.setLength(0);
    }

    @Override
    public DirectoryTree getDirectory() {
        return this.dt.computeIfAbsent("dt", d -> this.dtFactory.produce(this.fm, this.getLocation(), f -> BashUtils.append((StringBuffer)this.stage, (String)f.getPath().toString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T recoverState(Supplier<T> result) {
        String corrId = UUID.randomUUID().toString().substring(1, 3);
        log.debug("File manager state #{} saving...", (Object)corrId);
        PosixPath pwd = this.fm.getCurrent();
        try {
            T t = result.get();
            return t;
        }
        finally {
            this.fm.go(pwd);
            log.debug("File manager state #{} recovered.", (Object)corrId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T setupDir(Supplier<T> result) {
        String corrId = UUID.randomUUID().toString().substring(1, 3);
        log.debug("File manager state #{} saving...", (Object)corrId);
        PosixPath pwd = this.fm.getCurrent();
        try {
            if (!pwd.equals((Object)this.getLocation())) {
                this.fm.makeDir(this.getLocation());
                this.fm.go(this.getLocation());
            }
            T t = result.get();
            return t;
        }
        finally {
            if (!pwd.equals((Object)this.getLocation())) {
                this.fm.go(pwd);
            }
            log.debug("File manager state #{} recovered.", (Object)corrId);
        }
    }

    protected void setupDir(Runnable result) {
        this.setupDir(() -> {
            result.run();
            return 0;
        });
    }
}

