/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.config.DirectoryTreeFactory;
import io.github.andreyzebin.gitSql.git.AbstractClient;
import io.github.andreyzebin.gitSql.git.BranchHead;
import io.github.andreyzebin.gitSql.git.DefaultConfigurations;
import io.github.andreyzebin.gitSql.git.GitAuth;
import io.github.andreyzebin.gitSql.git.GitBindings;
import io.github.andreyzebin.gitSql.git.GitConfigurations;
import io.github.andreyzebin.gitSql.git.LocalSource;
import io.github.zebin.javabash.process.TextTerminal;
import io.github.zebin.javabash.sandbox.AllFileManager;
import io.github.zebin.javabash.sandbox.BashUtils;
import io.github.zebin.javabash.sandbox.PosixPath;
import io.github.zebin.javabash.sandbox.WorkingDirectory;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteOrigin
extends AbstractClient {
    private static final Logger log = LoggerFactory.getLogger(RemoteOrigin.class);
    protected String gitUri;
    private final TextTerminal bash;
    private final AllFileManager fm;
    private final GitAuth authStrategy;
    protected Path root;
    private final String branch;
    private String defaultBranch;
    private final Path home;
    private final GitConfigurations configurations;
    private final DirectoryTreeFactory dtf;

    public RemoteOrigin(String gitUri, AllFileManager bash, GitAuth authStrategy) {
        this(gitUri, bash, authStrategy, null, new DefaultConfigurations(bash), WorkingDirectory::new);
    }

    public RemoteOrigin(String gitUri, AllFileManager bash, GitAuth authStrategy, String branch) {
        this(gitUri, bash, authStrategy, branch, new DefaultConfigurations(bash), WorkingDirectory::new);
    }

    public RemoteOrigin(String gitUri, AllFileManager fm, GitAuth authStrategy, String branch, GitConfigurations configurations, DirectoryTreeFactory dtf) {
        super(fm, dtf);
        this.dtf = dtf;
        this.fm = fm;
        this.branch = branch;
        this.gitUri = gitUri;
        this.bash = fm.getTerminal();
        this.authStrategy = authStrategy;
        this.home = configurations.getHomeTemporaryDir();
        this.configurations = configurations;
    }

    public LocalSource getLocal() {
        return new LocalSource(this.getRoot(), this.fm);
    }

    @Override
    public void close() throws Exception {
        if (this.root != null) {
            this.setupDir(() -> {
                log.debug("Cleaning up temporary git root...");
                this.fm.goUp();
                this.bash.eval("rm -rf " + this.root.getFileName().toString());
            });
        }
    }

    public void withTerminal(Consumer<TextTerminal> evals) throws Exception {
        if (this.root != null) {
            this.setupDir(() -> evals.accept(this.bash));
        }
    }

    @Override
    public Stream<BranchHead> listBranches() {
        this.authStrategy.beforeRemote(this.bash);
        Stream<BranchHead> remoteBranches = GitBindings.getRemoteBranches(this.authStrategy.injectAuth(this.gitUri), this.bash, this.authStrategy.useAuthHeader());
        this.authStrategy.afterRemote(this.bash);
        return remoteBranches;
    }

    @Override
    public Path getRoot() {
        if (this.root == null) {
            log.debug("Initializing Git root...");
            return this.recoverState(() -> {
                String tempDirName = this.configurations.getTemporaryName(this.gitUri, this.branch);
                try {
                    PosixPath girRoot = PosixPath.of((Path)this.home).climb(PosixPath.ofPosix((String)tempDirName));
                    this.fm.makeDir(girRoot);
                    this.fm.go(girRoot);
                    this.authStrategy.beforeRemote(this.bash);
                    GitBindings.clone(".", this.bash, this.authStrategy.injectAuth(this.gitUri), false, this.authStrategy.useAuthHeader(), null);
                    this.authStrategy.afterRemote(this.bash);
                    this.root = girRoot.toPath();
                    return this.root;
                }
                catch (Exception e) {
                    log.error("Error while loading from remote: ", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
        return this.root;
    }

    @Override
    public void push() {
        if (this.root != null) {
            BashUtils.lockDir((TextTerminal)this.bash, () -> {
                this.bash.eval("cd " + BashUtils.encode((Path)this.getRoot()));
                this.authStrategy.beforeRemote(this.bash);
                GitBindings.push(this.bash);
                this.authStrategy.afterRemote(this.bash);
                return 0;
            });
        }
    }

    @Override
    public void setOrigin(String origin) {
    }

    @Override
    public void pull() {
        BashUtils.lockDir((TextTerminal)this.bash, () -> {
            this.bash.eval("cd " + BashUtils.encode((Path)this.getRoot()));
            this.authStrategy.beforeRemote(this.bash);
            GitBindings.pullAll(this.bash);
            this.authStrategy.afterRemote(this.bash);
            return 0;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteOrigin that = (RemoteOrigin)o;
        return Objects.equals(this.gitUri, that.gitUri) && Objects.equals(this.branch, that.branch);
    }

    public int hashCode() {
        return Objects.hash(this.gitUri, this.branch);
    }
}

