/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.FileSystem;
import io.github.andreyzebin.gitSql.FileSystemUtils;
import io.github.andreyzebin.gitSql.sql.CommitsIndex;
import io.github.andreyzebin.gitSql.sql.PersistedIndex;
import io.github.andreyzebin.gitSql.sql.SqlUtils;
import java.io.Reader;
import java.nio.file.Path;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesIndex
extends PersistedIndex {
    private static final Logger log = LoggerFactory.getLogger(FilesIndex.class);
    private final FileSystem fileSystem;
    private final Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers;
    public static final Map<Function<String, Boolean>, BiFunction<String, Reader, String>> JSON_MAPPERS = Map.of(f -> f.endsWith(".json"), (f, r) -> FileSystemUtils.readLines(r).collect(Collectors.joining(System.lineSeparator())));

    public FilesIndex(FileSystem fileSystem, Path storeDir, Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers) {
        super(storeDir);
        this.fileSystem = fileSystem;
        this.mappers = mappers;
    }

    public static FilesIndex of(FileSystem fileSystem, Path storeDir, Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers) {
        return new FilesIndex(fileSystem, storeDir, mappers);
    }

    public static BiFunction<FileSystem, Path, FilesIndex> of(Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers) {
        return (a, b) -> new FilesIndex((FileSystem)a, (Path)b, mappers);
    }

    @Override
    protected void createSchema() throws SQLException {
        try (Statement dml = this.getConnection().createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS files\n(\n    ID      INT          auto_increment,\n    path    VARCHAR(256) NOT NULL,\n    data    JSON         NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (path)\n);";
            log.debug(CommitsIndex.renderSqlLog("CREATE TABLE IF NOT EXISTS files\n(\n    ID      INT          auto_increment,\n    path    VARCHAR(256) NOT NULL,\n    data    JSON         NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (path)\n);"));
            dml.execute("CREATE TABLE IF NOT EXISTS files\n(\n    ID      INT          auto_increment,\n    path    VARCHAR(256) NOT NULL,\n    data    JSON         NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (path)\n);");
        }
        super.createSchema();
    }

    @Override
    protected void reindex() {
        try {
            this.fileSystem.find(p -> {
                if (!this.fileSystem.isDir((Path)p)) {
                    String fileName = p.getFileName().toString();
                    this.mappers.entrySet().stream().filter(cKey -> (Boolean)((Function)cKey.getKey()).apply(fileName)).findFirst().ifPresent(cF -> SqlUtils.merge(this.getConnection(), "files", "path", "data FORMAT JSON", p.toString(), (String)((BiFunction)cF.getValue()).apply(fileName, this.fileSystem.get((Path)p))));
                }
                return true;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

