package io.github.andreyzebin.gitSql;

import io.github.zebin.javabash.sandbox.PosixPath;

import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;

public class FileSystemSubDirectory implements FileSystem {

    private final FileSystem delegate;
    private final Path offset;

    public FileSystemSubDirectory(FileSystem delegate, Path offset) {
        this.delegate = delegate;
        this.offset = offset;
    }

    public FileSystemSubDirectory(FileSystem delegate, PosixPath offset) {
        this.delegate = delegate;
        this.offset = offset.toPath();
    }

    private Path toDelegate(Path rel) {
        return offset.resolve(rel);
    }

    private Path toProxy(Path delegateBy) {
        return offset.relativize(delegateBy);
    }

    @Override
    public Writer put(Path path) {
        return delegate.put(toDelegate(path));
    }

    @Override
    public boolean erase(Path path) {
        return delegate.erase(toDelegate(path));
    }

    @Override
    public Writer patch(Path path) {
        return delegate.patch(toDelegate(path));
    }

    @Override
    public Reader get(Path path) {
        return delegate.get(toDelegate(path));
    }

    @Override
    public boolean exists(Path path) {
        return delegate.exists(toDelegate(path));
    }

    @Override
    public boolean isDir(Path path) {
        return delegate.isDir(toDelegate(path));
    }

    @Override
    public int run(String cmd, Consumer<String> stdOut, Consumer<String> stdErr) {
        return delegate.run(cmd, stdOut, stdErr);
    }

    @Override
    public void find(Function<Path, Boolean> needContinue, Consumer<Path> sayBye, Comparator<Path> sorting) {
        delegate.find(
                (p) -> needContinue.apply(toProxy(p)),
                (p) -> sayBye.accept(toProxy(p)),
                sorting
        );
    }

    @Override
    public void flush() {
        delegate.flush();
    }

    @Override
    public FileSystem subTree(Path jump) {
        throw new RuntimeException("Unsupported!");
    }

    @Override
    public void close() throws Exception {
        // delegate.close();
    }
}
