package io.github.andreyzebin.gitSql.git;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public
class Change {

    private String file;
    private String type;

    @JsonIgnore
    public boolean isDeletion() {
        return type.equals("D");
    }

    @JsonIgnore
    public boolean isModification() {
        return type.equals("M");
    }

    @JsonIgnore
    public boolean isAddition() {
        return type.equals("A");
    }

    @JsonIgnore
    public boolean isUpdate() {
        return isAddition() || isModification();
    }
}
