/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.config;

import io.github.andreyzebin.gitSql.config.ConfigHistory;
import io.github.andreyzebin.gitSql.config.ConfigVersions;
import io.github.andreyzebin.gitSql.git.BranchHead;
import io.github.andreyzebin.gitSql.git.GitFs;
import io.github.zebin.javabash.sandbox.AllFileManager;
import io.github.zebin.javabash.sandbox.PosixPath;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestTree {
    private static final Logger log = LoggerFactory.getLogger(RequestTree.class);
    private final Function<String, GitFs> originFactory;
    private final Function<GitFs, ConfigVersions> versionsFactory;
    private final String trunk;
    private final AllFileManager tt;

    public RequestTree(Function<String, GitFs> originFactory, Function<GitFs, ConfigVersions> versionsFactory, String trunk, AllFileManager tt) {
        this.originFactory = originFactory;
        this.versionsFactory = versionsFactory;
        this.trunk = trunk;
        this.tt = tt;
    }

    public Set<String> listBranches() {
        return this.getGitApi(this.trunk).listBranches().map(BranchHead::getName).collect(Collectors.toSet());
    }

    public ConfigVersions getBranch(String branch) {
        return this.versionsFactory.apply(this.getGitApi(branch));
    }

    private GitFs getGitApi(String branch) {
        return this.originFactory.apply(branch);
    }

    public ConfigVersions getTrunk() {
        return this.getBranch(this.trunk);
    }

    public String getOffset(String branch) {
        return this.getOffset(branch, this.trunk);
    }

    public String getOffset(String branch, String baseBranch) {
        return this.getBranch(branch).listVersions().map(ConfigHistory.PropertiesVersion::getVersionHash).filter(v -> {
            GitFs trunkControl = this.getGitApi(baseBranch);
            return trunkControl.contains((String)v);
        }).findFirst().get();
    }

    public ConfigVersions createBranch(String baseBranch, String newBranch) {
        GitFs gfs = this.getGitApi(baseBranch);
        gfs.copy(baseBranch, newBranch);
        gfs.setUpstream(newBranch, "origin");
        return this.getBranch(newBranch);
    }

    public void rebase(String fromBranch, String branch, String destinationBranch) {
        GitFs trunkControl = this.getGitApi(branch);
        PosixPath location = trunkControl.getLocation();
        try {
            this.getBranch(branch).update();
            trunkControl.setBranch(fromBranch);
            trunkControl.setBranch(destinationBranch);
            trunkControl.setBranch(branch);
            trunkControl.rebase(destinationBranch, fromBranch, branch);
            trunkControl.push(true);
        }
        catch (RuntimeException e) {
            log.error("Rebase failed: ", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        PosixPath current = this.tt.getCurrent();
        this.tt.go(location);
        this.tt.getTerminal().exec(RequestTree.inject("git diff --check", new Object[0]), sb::append, sb::append);
        this.tt.go(current);
        if (sb.toString().lines().findAny().isPresent()) {
            trunkControl.reset();
            trunkControl.setBranch(branch);
        }
    }

    public boolean merge(String dstBranch, String sourceBranch, String sourceHash) {
        GitFs trunkControl = this.getGitApi(dstBranch);
        PosixPath location = trunkControl.getLocation();
        this.tt.go(location);
        try {
            this.getBranch(dstBranch).update();
            trunkControl.merge(sourceHash);
            trunkControl.push();
        }
        catch (RuntimeException e) {
            log.error("Merge failed: ", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        this.tt.getTerminal().exec(RequestTree.inject("git diff --check", new Object[0]), sb::append, sb::append);
        if (sb.toString().lines().findAny().isPresent()) {
            trunkControl.reset();
            trunkControl.setBranch(dstBranch);
            return false;
        }
        return true;
    }

    public boolean merge(String sourceBranch, String sourceHash) {
        GitFs trunkControl = this.getGitApi(this.trunk);
        PosixPath location = trunkControl.getLocation();
        this.tt.go(location);
        try {
            trunkControl.merge(sourceHash);
            trunkControl.push();
        }
        catch (RuntimeException e) {
            log.error("Merge failed: ", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        this.tt.getTerminal().exec(RequestTree.inject("git diff --check", new Object[0]), sb::append, sb::append);
        if (sb.toString().lines().findAny().isPresent()) {
            trunkControl.reset();
            trunkControl.setBranch(this.trunk);
            return false;
        }
        return true;
    }

    public static String inject(String gitMerge, Object ... ff) {
        return String.format(gitMerge, ff);
    }
}

