/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.sql.CommitsIndex;
import io.github.andreyzebin.gitSql.sql.PersistedIndex;
import io.github.andreyzebin.gitSql.sql.SqlUtils;
import io.github.andreyzebin.gitSql.sql.TableSource;
import java.nio.file.Path;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperAggregation
extends PersistedIndex {
    private static final Logger log = LoggerFactory.getLogger(SuperAggregation.class);
    private final Collection<TableSource> sources;

    public SuperAggregation(Path storeDir, Collection<TableSource> sources) {
        super(storeDir);
        this.sources = sources;
    }

    @Override
    protected void createSchema() throws SQLException {
        super.createSchema();
        log.info("Creating schema...");
        try (Statement dml = this.getConnection().createStatement();){
            String dml2 = new SqlUtils.SchemaBuilder("source_log").withColumn("hash").withColumn("timestamp").withColumn("version").withMerge("hash").withIndex("UNIQUE NULLS ALL DISTINCT (hash)").toDML();
            log.debug("Executing DML: " + CommitsIndex.renderSqlLog(dml2));
            dml.execute(dml2);
            this.sources.forEach(cSource -> {
                try {
                    String dml1 = cSource.createSchema().toDML();
                    log.debug("Executing DML: " + CommitsIndex.renderSqlLog(dml1));
                    dml.execute(dml1);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void init() {
        super.init();
        try {
            this.createSchema();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.reindex();
    }

    @Override
    protected void reindex() {
        super.reindex();
        this.sources.forEach(cSource -> {
            Optional<Stream> hashLog = SqlUtils.streamRows(SqlUtils::streamFields, SqlUtils.query(this.getConnection(), "SELECT version FROM source_log WHERE hash = " + cSource.hashCode() + ";", new String[0])).findFirst();
            if (hashLog.isPresent()) {
                String version = (String)hashLog.get().filter(cEntr -> ((String)cEntr.getKey()).equalsIgnoreCase("version")).findFirst().get().getValue();
                cSource = cSource.updates(version);
            }
            SqlUtils.merge(this.getConnection(), "source_log", List.of("hash"), Map.of("hash", String.valueOf(cSource.hashCode()), "timestamp", String.valueOf(LocalDateTime.now()), "version", cSource.version()));
            TableSource finalCSource = cSource;
            cSource.rows().forEach(cRow -> {
                try {
                    SqlUtils.merge(this.getConnection(), finalCSource.createSchema().getAlias(), finalCSource.createSchema().getMergeColumns(), cRow);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        });
    }

    @Override
    public SuperAggregation drop() {
        return (SuperAggregation)super.drop();
    }
}

