/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import pl.project13.core.AheadBehind;
import pl.project13.core.GitCommitIdExecutionException;
import pl.project13.core.GitDataProvider;
import pl.project13.core.ProcessHandler;
import pl.project13.core.git.GitDescribeConfig;
import pl.project13.core.log.LogInterface;

public class NativeGitProvider
extends GitDataProvider {
    private transient ProcessRunner runner;
    final File dotGitDirectory;
    final long nativeGitTimeoutInMs;
    final File canonical;

    @Nonnull
    public static NativeGitProvider on(@Nonnull File dotGitDirectory, long nativeGitTimeoutInMs, @Nonnull LogInterface log) {
        return new NativeGitProvider(dotGitDirectory, nativeGitTimeoutInMs, log);
    }

    NativeGitProvider(@Nonnull File dotGitDirectory, long nativeGitTimeoutInMs, @Nonnull LogInterface log) {
        super(log);
        this.dotGitDirectory = dotGitDirectory;
        this.nativeGitTimeoutInMs = nativeGitTimeoutInMs;
        try {
            this.canonical = dotGitDirectory.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new RuntimeException(new GitCommitIdExecutionException("Passed a invalid directory, not a GIT repository: " + String.valueOf(dotGitDirectory), ex));
        }
    }

    @Override
    public void init() throws GitCommitIdExecutionException {
    }

    @Override
    public String getBuildAuthorName() throws GitCommitIdExecutionException {
        try {
            return this.runGitCommand(this.canonical, this.nativeGitTimeoutInMs, "config --get user.name");
        }
        catch (NativeCommandException e) {
            if (e.getExitCode() == 1) {
                return "";
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getBuildAuthorEmail() throws GitCommitIdExecutionException {
        try {
            return this.runGitCommand(this.canonical, this.nativeGitTimeoutInMs, "config --get user.email");
        }
        catch (NativeCommandException e) {
            if (e.getExitCode() == 1) {
                return "";
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void prepareGitToExtractMoreDetailedRepoInformation() throws GitCommitIdExecutionException {
    }

    @Override
    public String getBranchName() throws GitCommitIdExecutionException {
        if (this.evalCommitIsNotHead()) {
            return this.getBranchForCommitish(this.canonical);
        }
        return this.getBranchForHead(this.canonical);
    }

    private boolean evalCommitIsNotHead() {
        return this.evaluateOnCommit != null && !this.evaluateOnCommit.equals("HEAD");
    }

    private String getBranchForHead(File canonical) throws GitCommitIdExecutionException {
        String branch;
        try {
            branch = this.runGitCommand(canonical, this.nativeGitTimeoutInMs, "symbolic-ref --short " + this.evaluateOnCommit);
        }
        catch (NativeCommandException e) {
            String err = e.getStderr();
            if (err != null) {
                boolean noSymbolicRef = err.contains("ref " + this.evaluateOnCommit + " is not a symbolic ref");
                boolean noSuchRef = err.contains("No such ref: " + this.evaluateOnCommit);
                if (noSymbolicRef || noSuchRef) {
                    branch = this.getCommitId();
                }
                throw new GitCommitIdExecutionException(e);
            }
            throw new GitCommitIdExecutionException(e);
        }
        return branch;
    }

    private String getBranchForCommitish(File canonical) throws GitCommitIdExecutionException {
        String branch = this.runQuietGitCommand(canonical, this.nativeGitTimeoutInMs, "branch --points-at " + this.evaluateOnCommit);
        branch = branch != null && !branch.isEmpty() ? Stream.of(branch.split("\n")).map(s -> s.replaceAll("[\\* ]+", "")).filter(s -> !s.startsWith("(HEAD detached at")).collect(Collectors.joining(",")) : this.getCommitId();
        return branch;
    }

    @Override
    public String getGitDescribe() throws GitCommitIdExecutionException {
        String argumentsForGitDescribe = this.getArgumentsForGitDescribe(this.gitDescribe);
        return this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "describe" + argumentsForGitDescribe);
    }

    private String getArgumentsForGitDescribe(GitDescribeConfig describeConfig) {
        String matchOption;
        String dirtyMark;
        if (describeConfig == null) {
            return "";
        }
        StringBuilder argumentsForGitDescribe = new StringBuilder();
        boolean hasCommitish = this.evalCommitIsNotHead();
        if (hasCommitish) {
            argumentsForGitDescribe.append(" " + this.evaluateOnCommit);
        }
        if (describeConfig.isAlways()) {
            argumentsForGitDescribe.append(" --always");
        }
        if ((dirtyMark = describeConfig.getDirty()) != null && !dirtyMark.isEmpty()) {
            if (hasCommitish) {
                this.log.warn("You might use strange arguments since it's unfortunately not supported to have evaluateOnCommit and the --dirty flag for the describe command set at the same time");
            } else {
                argumentsForGitDescribe.append(" --dirty=").append(dirtyMark);
            }
        }
        if ((matchOption = describeConfig.getMatch()) != null && !matchOption.isEmpty()) {
            argumentsForGitDescribe.append(" --match=").append(matchOption);
        }
        argumentsForGitDescribe.append(" --abbrev=").append(describeConfig.getAbbrev());
        if (describeConfig.getTags()) {
            argumentsForGitDescribe.append(" --tags");
        }
        if (describeConfig.getForceLongFormat()) {
            argumentsForGitDescribe.append(" --long");
        }
        return argumentsForGitDescribe.toString();
    }

    @Override
    public String getCommitId() throws GitCommitIdExecutionException {
        boolean evaluateOnCommitIsSet = this.evalCommitIsNotHead();
        if (evaluateOnCommitIsSet) {
            String actualCommitId = this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "rev-list -n 1 " + this.evaluateOnCommit);
            return this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "rev-parse " + actualCommitId);
        }
        return this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "rev-parse HEAD");
    }

    @Override
    public String getAbbrevCommitId() throws GitCommitIdExecutionException {
        String commitId = this.getCommitId();
        String abbrevCommitId = "";
        if (commitId != null && !commitId.isEmpty()) {
            abbrevCommitId = commitId.substring(0, this.abbrevLength);
        }
        return abbrevCommitId;
    }

    @Override
    public boolean isDirty() throws GitCommitIdExecutionException {
        return !this.tryCheckEmptyRunGitCommand(this.canonical, this.nativeGitTimeoutInMs, "status -s");
    }

    @Override
    public String getCommitAuthorName() throws GitCommitIdExecutionException {
        return this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "log -1 --pretty=format:%an --no-show-signature " + this.evaluateOnCommit);
    }

    @Override
    public String getCommitAuthorEmail() throws GitCommitIdExecutionException {
        return this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "log -1 --pretty=format:%ae --no-show-signature " + this.evaluateOnCommit);
    }

    @Override
    public String getCommitMessageFull() throws GitCommitIdExecutionException {
        return this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "log -1 --pretty=format:%B --no-show-signature " + this.evaluateOnCommit);
    }

    @Override
    public String getCommitMessageShort() throws GitCommitIdExecutionException {
        return this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "log -1 --pretty=format:%s --no-show-signature " + this.evaluateOnCommit);
    }

    @Override
    public String getCommitTime() throws GitCommitIdExecutionException {
        String value = this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "log -1 --pretty=format:%ct --no-show-signature " + this.evaluateOnCommit);
        SimpleDateFormat smf = this.getSimpleDateFormatWithTimeZone();
        return smf.format(Long.parseLong(value) * 1000L);
    }

    @Override
    public String getCommitAuthorTime() throws GitCommitIdExecutionException {
        String value = this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "log -1 --pretty=format:%at --no-show-signature " + this.evaluateOnCommit);
        SimpleDateFormat smf = this.getSimpleDateFormatWithTimeZone();
        return smf.format(Long.parseLong(value) * 1000L);
    }

    @Override
    public String getCommitCommitterTime() throws GitCommitIdExecutionException {
        String value = this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "log -1 --pretty=format:%ct --no-show-signature " + this.evaluateOnCommit);
        SimpleDateFormat smf = this.getSimpleDateFormatWithTimeZone();
        return smf.format(Long.parseLong(value) * 1000L);
    }

    @Override
    public String getTags() throws GitCommitIdExecutionException {
        String result = this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "tag --contains " + this.evaluateOnCommit);
        return result.replace('\n', ',');
    }

    @Override
    public String getTag() throws GitCommitIdExecutionException {
        String result = this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "tag --points-at " + this.evaluateOnCommit);
        return result.replace('\n', ',');
    }

    @Override
    public String getRemoteOriginUrl() throws GitCommitIdExecutionException {
        return this.getOriginRemote(this.canonical, this.nativeGitTimeoutInMs);
    }

    @Override
    public String getClosestTagName() throws GitCommitIdExecutionException {
        try {
            StringBuilder argumentsForGitDescribe = new StringBuilder();
            argumentsForGitDescribe.append("describe " + this.evaluateOnCommit + " --abbrev=0");
            if (this.gitDescribe != null) {
                String matchOption;
                if (this.gitDescribe.getTags()) {
                    argumentsForGitDescribe.append(" --tags");
                }
                if ((matchOption = this.gitDescribe.getMatch()) != null && !matchOption.isEmpty()) {
                    argumentsForGitDescribe.append(" --match=").append(matchOption);
                }
            }
            return this.runGitCommand(this.canonical, this.nativeGitTimeoutInMs, argumentsForGitDescribe.toString());
        }
        catch (NativeCommandException nativeCommandException) {
            return "";
        }
    }

    @Override
    public String getClosestTagCommitCount() throws GitCommitIdExecutionException {
        String closestTagName = this.getClosestTagName();
        if (closestTagName != null && !closestTagName.trim().isEmpty()) {
            return this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "rev-list " + closestTagName + ".." + this.evaluateOnCommit + " --count");
        }
        return "";
    }

    @Override
    public String getTotalCommitCount() throws GitCommitIdExecutionException {
        return this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "rev-list " + this.evaluateOnCommit + " --count");
    }

    @Override
    public void finalCleanUp() throws GitCommitIdExecutionException {
    }

    private String getOriginRemote(File directory, long nativeGitTimeoutInMs) throws GitCommitIdExecutionException {
        try {
            String remoteUrl = this.runGitCommand(directory, nativeGitTimeoutInMs, "ls-remote --get-url");
            return this.stripCredentialsFromOriginUrl(remoteUrl);
        }
        catch (NativeCommandException nativeCommandException) {
            return null;
        }
    }

    private boolean tryCheckEmptyRunGitCommand(File directory, long nativeGitTimeoutInMs, String gitCommand) {
        try {
            String env = System.getenv("GIT_PATH");
            String exec = env == null ? "git" : env;
            String command = String.format("%s %s", exec, gitCommand);
            return this.getRunner().runEmpty(directory, nativeGitTimeoutInMs, command);
        }
        catch (IOException | GitCommitIdExecutionException ex) {
            this.log.error("Failed to run git command", ex);
            return false;
        }
    }

    private String runQuietGitCommand(File directory, long nativeGitTimeoutInMs, String gitCommand) throws GitCommitIdExecutionException {
        String env = System.getenv("GIT_PATH");
        String exec = env == null ? "git" : env;
        String command = String.format("%s %s", exec, gitCommand);
        try {
            return this.getRunner().run(directory, nativeGitTimeoutInMs, command.trim()).trim();
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException(e);
        }
    }

    private String runGitCommand(File directory, long nativeGitTimeoutInMs, String gitCommand) throws GitCommitIdExecutionException {
        String env = System.getenv("GIT_PATH");
        String exec = env == null ? "git" : env;
        String command = String.format("%s %s", exec, gitCommand);
        try {
            return this.getRunner().run(directory, nativeGitTimeoutInMs, command.trim()).trim();
        }
        catch (NativeCommandException e) {
            throw e;
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException(e);
        }
    }

    private ProcessRunner getRunner() {
        if (this.runner == null) {
            this.runner = new JavaProcessRunner();
        }
        return this.runner;
    }

    @Override
    public AheadBehind getAheadBehind() throws GitCommitIdExecutionException {
        try {
            Optional<String> remoteBranch = this.remoteBranch();
            if (!remoteBranch.isPresent()) {
                return AheadBehind.NO_REMOTE;
            }
            if (!this.offline) {
                this.fetch(remoteBranch.get());
            }
            String localBranchName = this.getBranchName();
            String ahead = this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "rev-list --right-only --count " + remoteBranch.get() + "..." + localBranchName);
            String behind = this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "rev-list --left-only --count " + remoteBranch.get() + "..." + localBranchName);
            return AheadBehind.of(ahead, behind);
        }
        catch (Exception e) {
            throw new GitCommitIdExecutionException("Failed to read ahead behind count: " + e.getMessage(), e);
        }
    }

    private Optional<String> remoteBranch() {
        try {
            String remoteRef = this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "symbolic-ref -q " + this.evaluateOnCommit);
            if (remoteRef == null || remoteRef.isEmpty()) {
                this.log.debug("Could not find ref for: " + this.evaluateOnCommit);
                return Optional.empty();
            }
            String remoteBranch = this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "for-each-ref --format=%(upstream:short) " + remoteRef);
            return Optional.ofNullable(remoteBranch.isEmpty() ? null : remoteBranch);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private void fetch(String remoteBranch) {
        try {
            this.runQuietGitCommand(this.canonical, this.nativeGitTimeoutInMs, "fetch " + remoteBranch.replaceFirst("/", " "));
        }
        catch (Exception e) {
            this.log.error("Failed to execute fetch", e);
        }
    }

    public void setEvaluateOnCommit(String evaluateOnCommit) {
        this.evaluateOnCommit = evaluateOnCommit;
    }

    public static class NativeCommandException
    extends GitCommitIdExecutionException {
        private static final long serialVersionUID = 3511033422542257748L;
        private final int exitCode;
        private final String command;
        private final File directory;
        private final String stdout;
        private final String stderr;

        public NativeCommandException(int exitCode, String command, File directory, String stdout, String stderr) {
            this.exitCode = exitCode;
            this.command = command;
            this.directory = directory;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getCommand() {
            return this.command;
        }

        public File getDirectory() {
            return this.directory;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        @Override
        public String getMessage() {
            return String.format("Git command exited with invalid status [%d]: directory: `%s`, command: `%s`, stdout: `%s`, stderr: `%s`", this.exitCode, this.directory, this.command, this.stdout, this.stderr);
        }
    }

    public static interface ProcessRunner {
        public String run(File var1, long var2, String var4) throws IOException, GitCommitIdExecutionException;

        public boolean runEmpty(File var1, long var2, String var4) throws IOException, GitCommitIdExecutionException;
    }

    protected static class JavaProcessRunner
    implements ProcessRunner {
        protected JavaProcessRunner() {
        }

        @Override
        public String run(File directory, long nativeGitTimeoutInMs, String command) throws IOException, GitCommitIdExecutionException {
            String output = "";
            try {
                StringBuilder commandResult = new StringBuilder();
                Consumer<String> stdoutConsumer = line -> {
                    if (line != null) {
                        commandResult.append((String)line).append('\n');
                    }
                };
                this.runProcess(directory, nativeGitTimeoutInMs, command, stdoutConsumer);
                output = commandResult.toString();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            return output;
        }

        @Override
        public boolean runEmpty(File directory, long nativeGitTimeoutInMs, String command) throws IOException, GitCommitIdExecutionException {
            AtomicBoolean empty = new AtomicBoolean(true);
            try {
                Consumer<String> stdoutConsumer = line -> empty.set(false);
                this.runProcess(directory, nativeGitTimeoutInMs, command, stdoutConsumer);
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            return empty.get();
        }

        private void runProcess(File directory, long nativeGitTimeoutInMs, String command, Consumer<String> stdoutLineConsumer) throws InterruptedException, IOException, GitCommitIdExecutionException {
            ProcessBuilder builder = new ProcessBuilder(command.split("\\s"));
            Process proc = builder.directory(directory).start();
            try (ProcessHandler processHandler = new ProcessHandler(proc, stdoutLineConsumer);){
                int exitValue = processHandler.exitValue(nativeGitTimeoutInMs, TimeUnit.MILLISECONDS);
                if (exitValue != 0) {
                    throw new NativeCommandException(exitValue, command, directory, "", processHandler.getStderr());
                }
            }
            catch (TimeoutException e) {
                throw new RuntimeException(String.format("GIT-Command '%s' did not finish in %d milliseconds", command, nativeGitTimeoutInMs), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(String.format("Executing GIT-Command '%s' threw an '%s' exception.", command, e.getMessage()), e);
            }
        }
    }
}

