/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.github.mainstringargs.alpaca.properties.AlpacaProperties;
import io.github.mainstringargs.alpaca.rest.AlpacaRequestBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlpacaRequest {
    private static Logger LOGGER = LogManager.getLogger(AlpacaRequest.class);
    private static final String USER_AGENT_KEY = "user-agent";
    private static final String API_KEY_ID = "APCA-API-KEY-ID";
    private static final String API_SECRET_KEY = "APCA-API-SECRET-KEY";
    private String keyId;
    private String secret;

    public AlpacaRequest(String keyId, String secret) {
        this.keyId = keyId;
        this.secret = secret;
    }

    public HttpResponse<JsonNode> invokeGet(AlpacaRequestBuilder builder) {
        HttpResponse response = null;
        try {
            LOGGER.debug("Get URL " + builder.getURL());
            response = Unirest.get((String)builder.getURL()).header(USER_AGENT_KEY, AlpacaProperties.USER_AGENT_VALUE).header(API_KEY_ID, this.keyId).header(API_SECRET_KEY, this.secret).asJson();
            LOGGER.debug("GET status: " + response.getStatus() + "\n\t\t\t\t\tstatusText: " + response.getStatusText() + "\n\t\t\t\t\tBody: " + response.getBody());
        }
        catch (UnirestException e) {
            LOGGER.info("UnirestException", (Throwable)e);
        }
        return response;
    }

    public HttpResponse<JsonNode> invokePost(AlpacaRequestBuilder builder) {
        HttpResponse response = null;
        try {
            LOGGER.debug("Post URL " + builder.getURL());
            LOGGER.debug("Post Body " + builder.getBodyAsJSON());
            response = Unirest.post((String)builder.getURL()).header(USER_AGENT_KEY, AlpacaProperties.USER_AGENT_VALUE).header(API_KEY_ID, this.keyId).header(API_SECRET_KEY, this.secret).body(builder.getBodyAsJSON()).asJson();
            LOGGER.debug("POST status: " + response.getStatus() + "\n\t\t\t\t\tstatusText: " + response.getStatusText() + "\n\t\t\t\t\tBody: " + response.getBody());
        }
        catch (UnirestException e) {
            LOGGER.info("UnirestException", (Throwable)e);
        }
        return response;
    }

    public HttpResponse<JsonNode> invokeDelete(AlpacaRequestBuilder builder) {
        HttpResponse response = null;
        try {
            LOGGER.debug("Delete URL " + builder.getURL());
            response = Unirest.delete((String)builder.getURL()).header(USER_AGENT_KEY, AlpacaProperties.USER_AGENT_VALUE).header(API_KEY_ID, this.keyId).header(API_SECRET_KEY, this.secret).asJson();
            LOGGER.debug("DELETE status: " + response.getStatus() + "\n\t\t\t\t\tstatusText: " + response.getStatusText() + "\n\t\t\t\t\tBody: " + response.getBody());
        }
        catch (UnirestException e) {
            LOGGER.info("UnirestException", (Throwable)e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getResponseObject(HttpResponse<JsonNode> httpResponse, Type type) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLenient();
        Gson gson = gsonBuilder.create();
        Object responseObjectFromJson = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(httpResponse.getRawBody()));
            responseObjectFromJson = gson.fromJson((Reader)br, type);
        }
        catch (Exception e) {
            LOGGER.info("Exception", (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.info("IOException", (Throwable)e);
                }
            }
        }
        return (T)responseObjectFromJson;
    }
}

