/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.websocket;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mainstringargs.alpaca.enums.MessageType;
import io.github.mainstringargs.alpaca.websocket.AlpacaStreamListener;
import io.github.mainstringargs.alpaca.websocket.AlpacaWebsocketClient;
import io.github.mainstringargs.alpaca.websocket.AlpacaWebsocketClientEndpoint;
import io.github.mainstringargs.alpaca.websocket.message.AccountUpdateMessage;
import io.github.mainstringargs.alpaca.websocket.message.OrderUpdateMessage;
import io.github.mainstringargs.alpaca.websocket.message.UpdateMessage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlpacaWebsocketClient
implements AlpacaWebsocketClientEndpoint.MessageHandler {
    private String baseAccountUrl;
    private String keyId;
    private String secret;
    private List<AlpacaStreamListener> listeners = new ArrayList();
    private AlpacaWebsocketClientEndpoint clientEndPoint = null;
    private static Logger LOGGER = LogManager.getLogger(AlpacaWebsocketClient.class);
    private JsonObject authorizedObject = new JsonObject();

    public AlpacaWebsocketClient(String keyId, String secret, String baseAccountUrl) {
        this.authorizedObject.addProperty("stream", "authorization");
        JsonObject dataObject = new JsonObject();
        dataObject.addProperty("status", "authorized");
        dataObject.addProperty("action", "authenticate");
        this.authorizedObject.add("data", (JsonElement)dataObject);
        this.keyId = keyId;
        this.secret = secret;
        this.baseAccountUrl = baseAccountUrl.replace("https", "wss") + "/stream";
    }

    public void addListener(AlpacaStreamListener listener) {
        if (this.listeners.isEmpty()) {
            this.connect();
        }
        this.listeners.add(listener);
    }

    public void removeListener(AlpacaStreamListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.disconnect();
        }
    }

    private void connect() {
        try {
            this.clientEndPoint = new AlpacaWebsocketClientEndpoint(new URI(this.baseAccountUrl));
            this.clientEndPoint.addMessageHandler((AlpacaWebsocketClientEndpoint.MessageHandler)this);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        JsonObject authRequest = new JsonObject();
        authRequest.addProperty("action", "authenticate");
        JsonObject payload = new JsonObject();
        payload.addProperty("key_id", this.keyId);
        payload.addProperty("secret_key", this.secret);
        authRequest.add("data", (JsonElement)payload);
        this.clientEndPoint.sendMessage(authRequest.toString());
    }

    private void disconnect() {
        try {
            this.clientEndPoint.getUserSession().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleMessage(JsonObject message) {
        if (message.has("stream")) {
            String streamType;
            switch (streamType = message.get("stream").getAsString()) {
                case "authorization": {
                    if (!this.authorizedObject.equals((Object)message)) break;
                    LOGGER.debug("Authorized by Alpaca " + message);
                    this.submitStreamRequest();
                    break;
                }
                case "listening": {
                    LOGGER.debug("Listening response " + message);
                    break;
                }
                case "trade_updates": {
                    this.sendStreamMessageToObservers(MessageType.ORDER_UPDATES, message);
                    break;
                }
                case "account_updates": {
                    this.sendStreamMessageToObservers(MessageType.ACCOUNT_UPDATES, message);
                }
            }
        } else {
            LOGGER.error("Invalid message received " + message);
        }
    }

    private synchronized void sendStreamMessageToObservers(MessageType messageType, JsonObject message) {
        for (AlpacaStreamListener observer : this.listeners) {
            UpdateMessage messageObject = this.getMessageToObject(messageType, message);
            if (observer.getMessageTypes() != null && !observer.getMessageTypes().isEmpty() && !observer.getMessageTypes().contains((Object)messageType)) continue;
            observer.streamUpdate(messageType, messageObject);
        }
    }

    private UpdateMessage getMessageToObject(MessageType messageType, JsonObject message) {
        if (message.has("data")) {
            JsonObject data = message.getAsJsonObject("data");
            switch (1.$SwitchMap$io$github$mainstringargs$alpaca$enums$MessageType[messageType.ordinal()]) {
                case 1: {
                    AccountUpdateMessage accountUpdateMessage = new AccountUpdateMessage(data);
                    return accountUpdateMessage;
                }
                case 2: {
                    OrderUpdateMessage orderUpdateMessage = new OrderUpdateMessage(data);
                    return orderUpdateMessage;
                }
            }
        }
        return null;
    }

    private void submitStreamRequest() {
        JsonObject streamRequest = new JsonObject();
        JsonArray array = new JsonArray();
        for (MessageType mType : this.getRegisteredMessageTypes()) {
            array.add(mType.getAPIName());
        }
        streamRequest.addProperty("action", "listen");
        JsonObject dataObject = new JsonObject();
        dataObject.add("streams", (JsonElement)array);
        streamRequest.add("data", (JsonElement)dataObject);
        this.clientEndPoint.sendMessage(streamRequest.toString());
    }

    public Set<MessageType> getRegisteredMessageTypes() {
        HashSet<MessageType> registeredMessageTypes = new HashSet<MessageType>();
        for (AlpacaStreamListener observer : this.listeners) {
            if (observer.getMessageTypes() == null || observer.getMessageTypes().isEmpty()) {
                registeredMessageTypes.addAll(Arrays.asList(MessageType.values()));
                break;
            }
            registeredMessageTypes.addAll(observer.getMessageTypes());
        }
        return registeredMessageTypes;
    }
}

