/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.websocket.message;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mainstringargs.alpaca.domain.Account;
import io.github.mainstringargs.alpaca.enums.MessageType;
import io.github.mainstringargs.alpaca.websocket.message.UpdateMessage;

public class AccountUpdateMessage
implements UpdateMessage {
    private Account account;

    public AccountUpdateMessage(JsonObject data) {
        JsonObject jsonAccount = data.getAsJsonObject();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLenient();
        Gson gson = gsonBuilder.create();
        this.account = (Account)gson.fromJson((JsonElement)jsonAccount, Account.class);
    }

    public Account getAccount() {
        return this.account;
    }

    public String toString() {
        return "AccountUpdateMessage [account=" + this.account + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.account == null ? 0 : this.account.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountUpdateMessage other = (AccountUpdateMessage)obj;
        return !(this.account == null ? other.account != null : !this.account.equals(other.account));
    }

    public MessageType getMessageType() {
        return MessageType.ACCOUNT_UPDATES;
    }
}

