/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.websocket.message;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mainstringargs.alpaca.Utilities;
import io.github.mainstringargs.alpaca.domain.Order;
import io.github.mainstringargs.alpaca.enums.MessageType;
import io.github.mainstringargs.alpaca.enums.OrderEvent;
import io.github.mainstringargs.alpaca.websocket.message.UpdateMessage;
import java.time.LocalDateTime;

public class OrderUpdateMessage
implements UpdateMessage {
    private OrderEvent event = OrderEvent.NEW;
    private Double price;
    private LocalDateTime timestamp;
    private Order order;

    public OrderUpdateMessage(JsonObject data) {
        if (data.has("event")) {
            String jsonEvent = data.get("event").getAsString();
            this.event = OrderEvent.fromAPIName(jsonEvent);
        }
        this.price = null;
        if (data.has("price")) {
            String jsonPrice = data.get("price").getAsString();
            this.price = Double.parseDouble(jsonPrice);
        }
        this.timestamp = null;
        if (data.has("timestamp")) {
            String jsonTimeStamp = data.get("timestamp").getAsString();
            this.timestamp = Utilities.fromDateTimeString(jsonTimeStamp);
        }
        this.order = null;
        if (data.has("order")) {
            JsonObject jsonOrder = data.get("order").getAsJsonObject();
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.setLenient();
            Gson gson = gsonBuilder.create();
            this.order = (Order)gson.fromJson((JsonElement)jsonOrder, Order.class);
        }
    }

    public String toString() {
        return "OrderUpdateMessage [event=" + (Object)((Object)this.event) + ", price=" + this.price + ", timestamp=" + this.timestamp + ", order=" + this.order + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        result = 31 * result + (this.order == null ? 0 : this.order.hashCode());
        result = 31 * result + (this.price == null ? 0 : this.price.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderUpdateMessage other = (OrderUpdateMessage)obj;
        if (this.event != other.event) {
            return false;
        }
        if (this.order == null ? other.order != null : !this.order.equals(other.order)) {
            return false;
        }
        if (this.price == null ? other.price != null : !this.price.equals(other.price)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }

    public OrderEvent getEvent() {
        return this.event;
    }

    public Double getPrice() {
        return this.price;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public Order getOrder() {
        return this.order;
    }

    public MessageType getMessageType() {
        return MessageType.ORDER_UPDATES;
    }
}

