/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.jdk.client;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.glassfish.tyrus.container.jdk.client.JdkUpgradeRequest;

class HttpRequestBuilder {
    private static final String ENCODING = "ISO-8859-1";
    private static final String LINE_SEPARATOR = "\r\n";
    private static final String HTTP_VERSION = "HTTP/1.1";

    HttpRequestBuilder() {
    }

    private static void appendUpgradeHeaders(StringBuilder request, JdkUpgradeRequest upgradeRequest) {
        for (Map.Entry<String, List<String>> header : upgradeRequest.getHeaders().entrySet()) {
            StringBuilder value = new StringBuilder();
            for (String valuePart : header.getValue()) {
                if (value.length() != 0) {
                    value.append(", ");
                }
                value.append(valuePart);
            }
            HttpRequestBuilder.appendHeader(request, header.getKey(), value.toString());
        }
    }

    private static void appendHeader(StringBuilder request, String key, String value) {
        request.append(key);
        request.append(":");
        request.append(value);
        request.append(LINE_SEPARATOR);
    }

    static ByteBuffer build(JdkUpgradeRequest upgradeRequest) {
        StringBuilder request = new StringBuilder();
        request.append(upgradeRequest.getHttpMethod());
        request.append(" ");
        request.append(upgradeRequest.getRequestUri());
        request.append(" ");
        request.append(HTTP_VERSION);
        request.append(LINE_SEPARATOR);
        HttpRequestBuilder.appendUpgradeHeaders(request, upgradeRequest);
        request.append(LINE_SEPARATOR);
        String requestStr = request.toString();
        byte[] bytes = requestStr.getBytes(Charset.forName(ENCODING));
        return ByteBuffer.wrap(bytes);
    }
}

