/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Ewallet {
    private String partnerReferenceNo;
    private String merchantId;
    private String subMerchantId;
    private String externalStoreId;
    private String validUpTo;
    private String pointOfInitiation;
    private Map<String, Object> amount;
    private Map<String, Object> additionalInfo;
    private List<Map<String, String>> urlParam;

    public Ewallet(String partnerReferenceNo, String merchantId, String subMerchantId, String externalStoreId, String validUpTo, String pointOfInitiation, Map<String, Object> amount, Map<String, Object> additionalInfo, List<Map<String, String>> urlParam) {
        this.partnerReferenceNo = partnerReferenceNo;
        this.merchantId = merchantId;
        this.subMerchantId = subMerchantId;
        this.externalStoreId = externalStoreId;
        this.validUpTo = validUpTo;
        this.pointOfInitiation = pointOfInitiation;
        this.amount = amount;
        this.additionalInfo = additionalInfo;
        this.urlParam = urlParam;
    }

    public static EwalletBuilder builder() {
        return new EwalletBuilder();
    }

    public String getPartnerReferenceNo() {
        return this.partnerReferenceNo;
    }

    public void setPartnerReferenceNo(String partnerReferenceNo) {
        this.partnerReferenceNo = partnerReferenceNo;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getSubMerchantId() {
        return this.subMerchantId;
    }

    public void setSubMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
    }

    public String getExternalStoreId() {
        return this.externalStoreId;
    }

    public void setExternalStoreId(String externalStoreId) {
        this.externalStoreId = externalStoreId;
    }

    public String getValidUpTo() {
        return this.validUpTo;
    }

    public void setValidUpTo(String validUpTo) {
        this.validUpTo = validUpTo;
    }

    public String getPointOfInitiation() {
        return this.pointOfInitiation;
    }

    public void setPointOfInitiation(String pointOfInitiation) {
        this.pointOfInitiation = pointOfInitiation;
    }

    public Map<String, Object> getAmount() {
        return this.amount;
    }

    public void setAmount(Map<String, Object> amount) {
        this.amount = amount;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public List<Map<String, String>> getUrlParam() {
        return this.urlParam;
    }

    public void setUrlParam(List<Map<String, String>> urlParam) {
        this.urlParam = urlParam;
    }

    public static class EwalletBuilder {
        private String partnerReferenceNo;
        private String merchantId;
        private String subMerchantId;
        private String externalStoreId;
        private String validUpTo;
        private String pointOfInitiation;
        private Map<String, Object> amount;
        private Map<String, Object> additionalInfo;
        private Map<String, Object> totalAmount;
        private List<Map<String, String>> urlParam;

        public EwalletBuilder amount(String value, String currency) {
            HashMap<String, Object> amountMap = new HashMap<String, Object>();
            amountMap.put("value", value);
            amountMap.put("currency", currency);
            this.amount = amountMap;
            return this;
        }

        public EwalletBuilder urlParam(String[][] urlParams) {
            ArrayList<Map<String, String>> urlParamList = new ArrayList<Map<String, String>>();
            for (String[] params : urlParams) {
                if (params.length != 3) continue;
                HashMap<String, String> paramListMap = new HashMap<String, String>();
                paramListMap.put("url", params[0]);
                paramListMap.put("type", params[1]);
                paramListMap.put("isDeeplink", params[2]);
                urlParamList.add(paramListMap);
            }
            this.urlParam = urlParamList;
            return this;
        }

        EwalletBuilder() {
        }

        public EwalletBuilder partnerReferenceNo(String partnerReferenceNo) {
            this.partnerReferenceNo = partnerReferenceNo;
            return this;
        }

        public EwalletBuilder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public EwalletBuilder subMerchantId(String subMerchantId) {
            this.subMerchantId = subMerchantId;
            return this;
        }

        public EwalletBuilder externalStoreId(String externalStoreId) {
            this.externalStoreId = externalStoreId;
            return this;
        }

        public EwalletBuilder validUpTo(String validUpTo) {
            this.validUpTo = validUpTo;
            return this;
        }

        public EwalletBuilder pointOfInitiation(String pointOfInitiation) {
            this.pointOfInitiation = pointOfInitiation;
            return this;
        }

        public EwalletBuilder additionalInfo(Map<String, Object> additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public Ewallet build() {
            return new Ewallet(this.partnerReferenceNo, this.merchantId, this.subMerchantId, this.externalStoreId, this.validUpTo, this.pointOfInitiation, this.amount, this.additionalInfo, this.urlParam);
        }

        public String toString() {
            return "Ewallet.EwalletBuilder(partnerReferenceNo=" + this.partnerReferenceNo + ", merchantId=" + this.merchantId + ", subMerchantId=" + this.subMerchantId + ", externalStoreId=" + this.externalStoreId + ", validUpTo=" + this.validUpTo + ", pointOfInitiation=" + this.pointOfInitiation + ", amount=" + String.valueOf(this.amount) + ", additionalInfo=" + String.valueOf(this.additionalInfo) + ", urlParam=" + String.valueOf(this.urlParam) + ")";
        }
    }
}

