/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.model;

import java.util.HashMap;
import java.util.Map;

public class Qris {
    private String partnerReferenceNo;
    private String merchantId;
    private String storeId;
    private String validityPeriod;
    private Map<String, Object> amount;
    private Map<String, Object> additionalInfo;

    public Qris(String partnerReferenceNo, String merchantId, String storeId, String validityPeriod, Map<String, Object> amount, Map<String, Object> additionalInfo) {
        this.partnerReferenceNo = partnerReferenceNo;
        this.merchantId = merchantId;
        this.storeId = storeId;
        this.validityPeriod = validityPeriod;
        this.amount = amount;
        this.additionalInfo = additionalInfo;
    }

    public static QrisBuilder builder() {
        return new QrisBuilder();
    }

    public String getPartnerReferenceNo() {
        return this.partnerReferenceNo;
    }

    public void setPartnerReferenceNo(String partnerReferenceNo) {
        this.partnerReferenceNo = partnerReferenceNo;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(String validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public Map<String, Object> getAmount() {
        return this.amount;
    }

    public void setAmount(Map<String, Object> amount) {
        this.amount = amount;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public static class QrisBuilder {
        private String partnerReferenceNo;
        private String merchantId;
        private String storeId;
        private String validityPeriod;
        private Map<String, Object> amount;
        private Map<String, Object> additionalInfo;

        public QrisBuilder amount(String value, String currency) {
            HashMap<String, Object> amountMap = new HashMap<String, Object>();
            amountMap.put("value", value);
            amountMap.put("currency", currency);
            this.amount = amountMap;
            return this;
        }

        public QrisBuilder additionalInfo(String goodsNm, String billingNm, String billingPhone, String billingEmail, String billingCity, String billingAddr, String billingState, String billingPostCd, String billingCountry, String callBackUrl, String dbProcessUrl, String userIP, String cartData, String mitraCd, String msId, String msFee, String msFeeType, String mbFee, String mbFeeType) {
            HashMap<String, Object> additonalInfoMap = new HashMap<String, Object>();
            additonalInfoMap.put("goodsNm", goodsNm);
            additonalInfoMap.put("billingNm", billingNm);
            additonalInfoMap.put("billingPhone", billingPhone);
            additonalInfoMap.put("billingEmail", billingEmail);
            additonalInfoMap.put("billingCity", billingCity);
            additonalInfoMap.put("billingAddr", billingAddr);
            additonalInfoMap.put("billingState", billingState);
            additonalInfoMap.put("billingPostCd", billingPostCd);
            additonalInfoMap.put("billingCountry", billingCountry);
            additonalInfoMap.put("callBackUrl", callBackUrl);
            additonalInfoMap.put("dbProcessUrl", dbProcessUrl);
            additonalInfoMap.put("userIP", userIP);
            additonalInfoMap.put("cartData", cartData);
            additonalInfoMap.put("mitraCd", mitraCd);
            additonalInfoMap.put("msId", msId);
            additonalInfoMap.put("msFee", msFee);
            additonalInfoMap.put("msFeeType", msFeeType);
            additonalInfoMap.put("mbFee", mbFee);
            additonalInfoMap.put("mbFeeType", mbFeeType);
            this.additionalInfo = additonalInfoMap;
            return this;
        }

        QrisBuilder() {
        }

        public QrisBuilder partnerReferenceNo(String partnerReferenceNo) {
            this.partnerReferenceNo = partnerReferenceNo;
            return this;
        }

        public QrisBuilder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public QrisBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public QrisBuilder validityPeriod(String validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        public Qris build() {
            return new Qris(this.partnerReferenceNo, this.merchantId, this.storeId, this.validityPeriod, this.amount, this.additionalInfo);
        }

        public String toString() {
            return "Qris.QrisBuilder(partnerReferenceNo=" + this.partnerReferenceNo + ", merchantId=" + this.merchantId + ", storeId=" + this.storeId + ", validityPeriod=" + this.validityPeriod + ", amount=" + String.valueOf(this.amount) + ", additionalInfo=" + String.valueOf(this.additionalInfo) + ")";
        }
    }
}

