/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.service.snap;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.nicepay.api.snap.PostEwalletRequest;
import io.github.nicepay.api.snap.PostPayoutRequest;
import io.github.nicepay.api.snap.PostQrisRequest;
import io.github.nicepay.api.snap.PostVaRequest;
import io.github.nicepay.exception.snap.NicepayErrorResponse;
import io.github.nicepay.model.AccessToken;
import io.github.nicepay.model.Cancel;
import io.github.nicepay.response.snap.NICEPayResponse;
import io.github.nicepay.utils.ApiUtils;
import io.github.nicepay.utils.LoggerPrint;
import io.github.nicepay.utils.NICEPay;
import java.io.IOException;
import java.net.SocketTimeoutException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class SnapCancelService {
    private static LoggerPrint print = new LoggerPrint();
    private static int retryCount = 0;

    public static <S> S callServiceVACancel(Cancel data, String accessToken, NICEPay config) throws IOException, InterruptedException {
        Gson gson = new Gson();
        Response response = null;
        NICEPayResponse nicePayResponse = null;
        ResponseBody errorResponse = null;
        String resClient = null;
        JsonObject jsonObject = null;
        PostVaRequest request = ApiUtils.createService(PostVaRequest.class, AccessToken.builder().build().getGrantType(), accessToken, gson.toJson((Object)data), config);
        Call<NICEPayResponse> callSync = request.cancelVa(data);
        try {
            response = callSync.execute();
            nicePayResponse = (NICEPayResponse)response.body();
            errorResponse = response.errorBody();
            resClient = nicePayResponse == null ? errorResponse.string() : gson.toJson((Object)nicePayResponse);
            ObjectMapper mapper = new ObjectMapper();
            jsonObject = JsonParser.parseString((String)resClient.toString()).getAsJsonObject();
            print.logInfoResponse("Response CancelVA :" + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject));
        }
        catch (SocketTimeoutException e) {
            System.out.println("wait 2sec");
            Thread.sleep(2000L);
            System.out.println("error " + e.getMessage());
            return (S)new NicepayErrorResponse("1004", e.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("wait 2sec");
            Thread.sleep(2000L);
        }
        return (S)nicePayResponse;
    }

    public static <S> S callServiceEwalletCancel(Cancel data, String accessToken, NICEPay config) throws IOException {
        Gson gson = new Gson();
        PostEwalletRequest request = ApiUtils.createService(PostEwalletRequest.class, AccessToken.builder().build().getGrantType(), accessToken, gson.toJson((Object)data), config);
        Call<NICEPayResponse> callSync = request.refundEwallet(data);
        Response response = null;
        NICEPayResponse nicePayResponse = null;
        ResponseBody errorResponse = null;
        String resClient = null;
        JsonObject jsonObject = null;
        try {
            response = callSync.execute();
            nicePayResponse = (NICEPayResponse)response.body();
            errorResponse = response.errorBody();
            resClient = nicePayResponse == null ? errorResponse.string() : gson.toJson((Object)nicePayResponse);
            ObjectMapper mapper = new ObjectMapper();
            jsonObject = JsonParser.parseString((String)resClient.toString()).getAsJsonObject();
            print.logInfoResponse("Response EwalletCancel :" + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (S)nicePayResponse;
    }

    public static <S> S callServicePayoutCancel(Cancel data, String accessToken, NICEPay config) throws IOException {
        Gson gson = new Gson();
        PostPayoutRequest request = ApiUtils.createService(PostPayoutRequest.class, AccessToken.builder().build().getGrantType(), accessToken, gson.toJson((Object)data), config);
        Call<NICEPayResponse> callSync = request.cancelPayout(data);
        Response response = null;
        NICEPayResponse nicePayResponse = null;
        ResponseBody errorResponse = null;
        String resClient = null;
        JsonObject jsonObject = null;
        try {
            response = callSync.execute();
            nicePayResponse = (NICEPayResponse)response.body();
            errorResponse = response.errorBody();
            resClient = nicePayResponse == null ? errorResponse.string() : gson.toJson((Object)nicePayResponse);
            ObjectMapper mapper = new ObjectMapper();
            jsonObject = JsonParser.parseString((String)resClient.toString()).getAsJsonObject();
            print.logInfoResponse("Response PayoutCancel :" + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (S)nicePayResponse;
    }

    public static <S> S callServicePayoutReject(Cancel data, String accessToken, NICEPay config) throws IOException {
        Gson gson = new Gson();
        PostPayoutRequest request = ApiUtils.createService(PostPayoutRequest.class, AccessToken.builder().build().getGrantType(), accessToken, gson.toJson((Object)data), config);
        Call<NICEPayResponse> callSync = request.rejectPayout(data);
        Response response = null;
        NICEPayResponse nicePayResponse = null;
        ResponseBody errorResponse = null;
        String resClient = null;
        JsonObject jsonObject = null;
        try {
            response = callSync.execute();
            nicePayResponse = (NICEPayResponse)response.body();
            errorResponse = response.errorBody();
            resClient = nicePayResponse == null ? errorResponse.string() : gson.toJson((Object)nicePayResponse);
            ObjectMapper mapper = new ObjectMapper();
            jsonObject = JsonParser.parseString((String)resClient.toString()).getAsJsonObject();
            print.logInfoResponse("Response PayoutReject :" + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (S)nicePayResponse;
    }

    public static <S> S callServiceQrisRefund(Cancel data, String accessToken, NICEPay config) throws IOException {
        Gson gson = new Gson();
        PostQrisRequest request = ApiUtils.createService(PostQrisRequest.class, AccessToken.builder().build().getGrantType(), accessToken, gson.toJson((Object)data), config);
        Call<NICEPayResponse> callSync = request.refundQris(data);
        Response response = null;
        NICEPayResponse nicePayResponse = null;
        ResponseBody errorResponse = null;
        String resClient = null;
        JsonObject jsonObject = null;
        try {
            response = callSync.execute();
            nicePayResponse = (NICEPayResponse)response.body();
            errorResponse = response.errorBody();
            resClient = nicePayResponse == null ? errorResponse.string() : gson.toJson((Object)nicePayResponse);
            ObjectMapper mapper = new ObjectMapper();
            jsonObject = JsonParser.parseString((String)resClient.toString()).getAsJsonObject();
            print.logInfoResponse("Response QrisRefund :" + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (S)nicePayResponse;
    }
}

