/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.service.snap;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.nicepay.api.snap.PostQrisRequest;
import io.github.nicepay.model.AccessToken;
import io.github.nicepay.model.Qris;
import io.github.nicepay.response.snap.NICEPayResponse;
import io.github.nicepay.utils.ApiUtils;
import io.github.nicepay.utils.LoggerPrint;
import io.github.nicepay.utils.NICEPay;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class SnapQrisService {
    private static LoggerPrint print = new LoggerPrint();

    public static <S> S callServiceQrisRegist(Qris data, String accessToken, NICEPay config) throws IOException {
        Gson gson = new Gson();
        PostQrisRequest request = ApiUtils.createService(PostQrisRequest.class, AccessToken.builder().build().getGrantType(), accessToken, gson.toJson((Object)data), config);
        Call<NICEPayResponse> callSync = request.registQris(data);
        Response response = null;
        NICEPayResponse nicePayResponse = null;
        ResponseBody errorResponse = null;
        String resClient = null;
        JsonObject jsonObject = null;
        try {
            response = callSync.execute();
            nicePayResponse = (NICEPayResponse)response.body();
            errorResponse = response.errorBody();
            resClient = nicePayResponse == null ? errorResponse.string() : gson.toJson((Object)nicePayResponse);
            ObjectMapper mapper = new ObjectMapper();
            jsonObject = JsonParser.parseString((String)resClient.toString()).getAsJsonObject();
            print.logInfoResponse("Response Qris Regist :" + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (S)nicePayResponse;
    }
}

