/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.service.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.nicepay.api.v2.VaRequestV2;
import io.github.nicepay.model.Cancel;
import io.github.nicepay.response.v2.NICEPayResponseV2;
import io.github.nicepay.utils.ApiUtils;
import io.github.nicepay.utils.LoggerPrint;
import io.github.nicepay.utils.NICEPay;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class V2CancelService {
    private static LoggerPrint print = new LoggerPrint();
    private static int retryCount = 0;

    public static <S> S callV2CancelVA(Cancel data, NICEPay config) throws IOException {
        Gson gson = new Gson();
        VaRequestV2 request = ApiUtils.createServiceV2(VaRequestV2.class, gson.toJson((Object)data), config);
        Call<NICEPayResponseV2> callSync = request.cancelVaV2(data);
        Response response = null;
        NICEPayResponseV2 nicePayResponse = null;
        ResponseBody errorResponse = null;
        String resClient = null;
        JsonObject jsonObject = null;
        try {
            response = callSync.execute();
            nicePayResponse = (NICEPayResponseV2)response.body();
            errorResponse = response.errorBody();
            resClient = nicePayResponse == null ? errorResponse.string() : gson.toJson((Object)nicePayResponse);
            ObjectMapper mapper = new ObjectMapper();
            jsonObject = JsonParser.parseString((String)resClient.toString()).getAsJsonObject();
            print.logInfoResponseV2("Response Cancel :" + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (S)nicePayResponse;
    }
}

