/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.utils;

import com.google.gson.GsonBuilder;
import io.github.nicepay.utils.LoggerPrint;
import io.github.nicepay.utils.NICEPay;
import io.github.nicepay.utils.SignatureUtils;
import java.time.Duration;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Invocation;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ApiUtils {
    private static LoggerPrint print = new LoggerPrint();
    private static Retrofit.Builder builder = new Retrofit.Builder().baseUrl(NICEPay.builder().getSnapApiURL()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
    private static Retrofit api;
    private static OkHttpClient.Builder httpClient;
    public static OkHttpClient.Builder httpClientTimeout;
    private static HttpLoggingInterceptor logging;

    public static <S> S createService(Class<S> serviceClass, String grandType, String accessToken, String data, NICEPay config) {
        httpClient.interceptors().clear();
        httpClient.addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder builder = null;
            print.logInfo("generate fullUrl :" + String.valueOf(chain.request().url()));
            String url = chain.request().url().encodedPath().replace("/nicepay", "");
            Optional.ofNullable(grandType).ifPresentOrElse(value -> print.logInfo("getToken pathUrl :" + url), () -> print.logInfo("generate pathUrl :" + url));
            try {
                String httpMethod = original.method();
                builder = original.newBuilder().headers(ApiUtils.getHeaders(httpMethod, grandType, accessToken, data, url, config));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Response response = chain.proceed(builder.build());
            String bodyString = response.body().string();
            MediaType contentType = response.body().contentType();
            ResponseBody responseBody = ResponseBody.create((String)bodyString, (MediaType)contentType);
            print.logInfoBody("Request Data " + new GsonBuilder().setPrettyPrinting().create().toJson(((Invocation)original.tag(Invocation.class)).arguments().get(0)));
            return response.newBuilder().body(responseBody).build();
        });
        builder.client(httpClient.build());
        builder.baseUrl(NICEPay.builder().isProduction(config.isProduction()).getSnapApiURL());
        api = builder.build();
        return (S)api.create(serviceClass);
    }

    public static <S> S createServiceConfig(Class<S> serviceClass, String grandType, String accessToken, String data, NICEPay config) {
        httpClient.interceptors().clear();
        httpClient.addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder builder = null;
            print.logInfo("generate fullUrl :" + String.valueOf(chain.request().url()));
            String url = chain.request().url().encodedPath().replace("/nicepay", "");
            Optional.ofNullable(grandType).ifPresentOrElse(value -> print.logInfo("getToken pathUrl :" + url), () -> print.logInfo("generate pathUrl :" + url));
            try {
                String httpMethod = original.method();
                builder = original.newBuilder().headers(ApiUtils.getHeaders(httpMethod, grandType, accessToken, data, url, config));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Response response = chain.proceed(builder.build());
            String bodyString = response.body().string();
            MediaType contentType = response.body().contentType();
            ResponseBody responseBody = ResponseBody.create((String)bodyString, (MediaType)contentType);
            print.logInfoBody("Request Data " + new GsonBuilder().setPrettyPrinting().create().toJson(((Invocation)original.tag(Invocation.class)).arguments().get(0)));
            return response.newBuilder().body(responseBody).build();
        });
        builder.client(httpClient.build());
        api = builder.build();
        return (S)api.create(serviceClass);
    }

    public static <S> S createTimeoutService(Class<S> serviceClass, String grandType, String accessToken, String data, NICEPay config) {
        httpClientTimeout.interceptors().clear();
        httpClientTimeout.addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder builder = null;
            print.logInfo("generate fullUrl :" + String.valueOf(chain.request().url()));
            String url = chain.request().url().encodedPath().replace("/nicepay", "");
            Optional.ofNullable(grandType).ifPresentOrElse(value -> print.logInfo("getToken pathUrl :" + url), () -> print.logInfo("generate pathUrl :" + url));
            try {
                String httpMethod = original.method();
                builder = original.newBuilder().headers(ApiUtils.getHeaders(httpMethod, grandType, accessToken, data, url, config));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Response response = chain.proceed(builder.build());
            String bodyString = response.body().string();
            MediaType contentType = response.body().contentType();
            ResponseBody responseBody = ResponseBody.create((String)bodyString, (MediaType)contentType);
            print.logInfoBody("Request Data Timeout" + new GsonBuilder().setPrettyPrinting().create().toJson(((Invocation)original.tag(Invocation.class)).arguments().get(0)));
            return response.newBuilder().body(responseBody).build();
        });
        builder.client(httpClientTimeout.build());
        api = builder.build();
        return (S)api.create(serviceClass);
    }

    private static Headers getHeaders(String httpMethod, String grandType, String accessToken, String data, String pathUrl, NICEPay config) throws Exception {
        HashMap<String, Object> headersMap = new HashMap<String, Object>();
        String partnerID = config.getPartnerId();
        String privateKey = config.getPrivateKey();
        String secretKey = config.getClientSecret();
        String externalID = config.getExternalID();
        String timeStamp = config.getTimestamp();
        headersMap.put("Content-Type", "application/json");
        if (grandType != null) {
            String stringToSign = partnerID + "|" + timeStamp;
            String signatureAccessToken = SignatureUtils.signSHA256RSA(stringToSign, privateKey);
            headersMap.put("X-TIMESTAMP", timeStamp);
            headersMap.put("X-CLIENT-KEY", partnerID);
            headersMap.put("X-SIGNATURE", signatureAccessToken);
        } else {
            String hashData = SignatureUtils.sha256EncodeHex(data);
            String signature = SignatureUtils.getSignature(httpMethod, accessToken, hashData, pathUrl, timeStamp, secretKey);
            headersMap.put("Authorization", "Bearer " + accessToken);
            headersMap.put("X-TIMESTAMP", timeStamp);
            headersMap.put("X-SIGNATURE", signature);
            headersMap.put("X-PARTNER-ID", partnerID);
            headersMap.put("X-EXTERNAL-ID", externalID);
            headersMap.put("CHANNEL-ID", partnerID + "01");
        }
        print.logInfoHeader("Request Header " + new GsonBuilder().setPrettyPrinting().create().toJson(headersMap));
        return Headers.of(headersMap);
    }

    public static <S> S createServiceV2(Class<S> serviceClass, String data, NICEPay config) {
        httpClient.interceptors().clear();
        httpClient.addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder builder = null;
            print.logInfoV2("generate fullUrl :" + String.valueOf(chain.request().url()));
            try {
                builder = original.newBuilder();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Response response = chain.proceed(builder.build());
            String bodyString = response.body().string();
            MediaType contentType = response.body().contentType();
            ResponseBody responseBody = ResponseBody.create((String)bodyString, (MediaType)contentType);
            print.logInfoBodyV2("Request Data " + new GsonBuilder().setPrettyPrinting().create().toJson(((Invocation)original.tag(Invocation.class)).arguments().get(0)));
            return response.newBuilder().body(responseBody).build();
        });
        builder.client(httpClient.build());
        builder.baseUrl(NICEPay.builder().isProduction(config.isProduction()).getSnapApiURL());
        api = builder.build();
        return (S)api.create(serviceClass);
    }

    static {
        httpClient = new OkHttpClient.Builder().connectTimeout(Duration.ofMillis(10000L));
        httpClientTimeout = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.MILLISECONDS).readTimeout(1L, TimeUnit.MILLISECONDS).writeTimeout(1L, TimeUnit.MILLISECONDS);
        logging = new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BASIC);
    }
}

