/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.utils;

import io.github.nicepay.utils.NICEPayConstants;

public class NICEPay {
    private String partnerId;
    private String clientSecret;
    private boolean isProduction;
    private String externalID;
    private String timestamp;
    private String privateKey;

    public NICEPay(String partnerId, String clientSecret, boolean isProduction, String externalID, String timestamp, String privateKey) {
        this.partnerId = partnerId;
        this.clientSecret = clientSecret;
        this.isProduction = isProduction;
        this.externalID = externalID;
        this.timestamp = timestamp;
        this.privateKey = privateKey;
    }

    public String toString() {
        return "NICEPay{partnerId='" + this.partnerId + "', clientSecret='" + this.clientSecret + "', isProduction=" + this.isProduction + "}";
    }

    public static NICEPayBuilder builder() {
        return new NICEPayBuilder();
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public boolean isProduction() {
        return this.isProduction;
    }

    public void setProduction(boolean isProduction) {
        this.isProduction = isProduction;
    }

    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public static class NICEPayBuilder {
        private String partnerId;
        private String clientSecret;
        private boolean isProduction;
        private String externalID;
        private String timestamp;
        private String privateKey;

        public String getSnapApiURL() {
            if (this.isProduction) {
                return NICEPayConstants.getProductionBaseUrl();
            }
            return NICEPayConstants.getSandboxBaseUrl();
        }

        NICEPayBuilder() {
        }

        public NICEPayBuilder partnerId(String partnerId) {
            this.partnerId = partnerId;
            return this;
        }

        public NICEPayBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public NICEPayBuilder isProduction(boolean isProduction) {
            this.isProduction = isProduction;
            return this;
        }

        public NICEPayBuilder externalID(String externalID) {
            this.externalID = externalID;
            return this;
        }

        public NICEPayBuilder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public NICEPayBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public NICEPay build() {
            return new NICEPay(this.partnerId, this.clientSecret, this.isProduction, this.externalID, this.timestamp, this.privateKey);
        }

        public String toString() {
            return "NICEPay.NICEPayBuilder(partnerId=" + this.partnerId + ", clientSecret=" + this.clientSecret + ", isProduction=" + this.isProduction + ", externalID=" + this.externalID + ", timestamp=" + this.timestamp + ", privateKey=" + this.privateKey + ")";
        }
    }
}

