/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.data.model;

import java.util.Map;

public class AccessToken {
    private String grantType;
    private Map<String, String> additionalInfo;

    public AccessToken(String grantType, Map<String, String> additionalInfo) {
        this.grantType = grantType;
        this.additionalInfo = additionalInfo;
    }

    public static AccessTokenBuilder builder() {
        return new AccessTokenBuilder();
    }

    public String getGrantType() {
        return this.grantType;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public static class AccessTokenBuilder {
        private String grantType;
        private Map<String, String> additionalInfo;

        AccessTokenBuilder() {
        }

        public AccessTokenBuilder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public AccessTokenBuilder additionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public AccessToken build() {
            return new AccessToken(this.grantType, this.additionalInfo);
        }

        public String toString() {
            return "AccessToken.AccessTokenBuilder(grantType=" + this.grantType + ", additionalInfo=" + String.valueOf(this.additionalInfo) + ")";
        }
    }
}

