/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.service.v1;

import io.github.nicepay.api.v1.RequestV1;
import io.github.nicepay.data.model.Card;
import io.github.nicepay.data.response.v1.NICEPayResponseV1;
import io.github.nicepay.service.v1.V1CommonService;
import io.github.nicepay.utils.ApiUtils;
import io.github.nicepay.utils.LoggerPrint;
import io.github.nicepay.utils.ModelUtils;
import io.github.nicepay.utils.NICEPay;
import io.github.nicepay.utils.SHA256Util;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class V1CardService
extends V1CommonService {
    private static LoggerPrint logger = new LoggerPrint();

    public static <S> S callCardRedirectRegistration(Card data, NICEPay config) throws IOException {
        RequestV1 cardV1 = ApiUtils.createServiceV1(RequestV1.class, config);
        data.setMerchantToken(SHA256Util.encrypt(data.getMerchantToken()));
        Call<ResponseBody> callSync = cardV1.orderRegist(ModelUtils.toMap(data));
        NICEPayResponseV1 nicePayResponse = new NICEPayResponseV1();
        String responseContent = null;
        try {
            Response responseExecute = callSync.execute();
            if (responseExecute.isSuccessful() && responseExecute.body() != null) {
                responseContent = ((ResponseBody)responseExecute.body()).string();
                nicePayResponse = ApiUtils.getApiMessageObject(responseContent, nicePayResponse);
                logger.logInfoResponseV1("Response Card Regist V1: " + responseContent);
            } else {
                ResponseBody errorResponse = responseExecute.errorBody();
                if (errorResponse != null) {
                    responseContent = errorResponse.string();
                    logger.logErrorV1("Error Response Card Regist V1: " + responseContent);
                }
            }
            logger.logInfoV1("END CALL V1 CARD REGISTRATION REQUEST");
        }
        catch (IOException ex) {
            logger.logErrorV1("IOException during V1 Card Registration Request: " + ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            logger.logErrorV1("Unexpected error during V1 Card Registration Request: " + ex.getMessage());
            ex.printStackTrace();
        }
        return (S)nicePayResponse;
    }
}

