/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.service.v1;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.nicepay.api.v1.RequestV1;
import io.github.nicepay.data.model.Cancel;
import io.github.nicepay.data.model.InquiryStatus;
import io.github.nicepay.data.response.v1.NICEPayResponseV1;
import io.github.nicepay.utils.ApiUtils;
import io.github.nicepay.utils.LoggerPrint;
import io.github.nicepay.utils.ModelUtils;
import io.github.nicepay.utils.NICEPay;
import io.github.nicepay.utils.SHA256Util;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class V1CommonService {
    private static LoggerPrint logger = new LoggerPrint();

    public static <S> S callInquiryStatus(InquiryStatus data, NICEPay config) throws IOException {
        logger.logInfoV1("START CALL V1 INQUIRY STATUS REQUEST");
        Gson gson = new Gson();
        RequestV1 requestV1 = ApiUtils.createServiceV1(RequestV1.class, config);
        data.setMerchantToken(SHA256Util.encrypt(data.getMerchantToken()));
        Call<NICEPayResponseV1> callSync = requestV1.inquiryStatus(ModelUtils.toMap(data));
        NICEPayResponseV1 nicePayResponse = new NICEPayResponseV1();
        Object resClient = null;
        try {
            Response response = callSync.execute();
            nicePayResponse = (NICEPayResponseV1)response.body();
            ResponseBody errorResponse = response.errorBody();
            resClient = nicePayResponse == null ? errorResponse.string() : gson.toJson((Object)nicePayResponse);
            logger.logInfoV1("END CALL V1 INQUIRY STATUS REQUEST");
        }
        catch (IOException ex) {
            logger.logErrorV1("IOException during V1 Inquiry Status Request: " + ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            logger.logErrorV1("Unexpected error during V1 Inquiry Status Request: " + ex.getMessage());
            ex.printStackTrace();
        }
        JsonObject jsonObject = JsonParser.parseString((String)resClient.toString()).getAsJsonObject();
        logger.logInfoResponseV1("Response Inquiry Status V1 :" + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject));
        return (S)nicePayResponse;
    }

    public static <S> S callCancelTransaction(Cancel data, NICEPay config) throws IOException {
        logger.logInfoV1("START CALL V1 CANCEL TRANSACTION REQUEST");
        Gson gson = new Gson();
        RequestV1 requestV1 = ApiUtils.createServiceV1(RequestV1.class, config);
        data.setMerchantToken(SHA256Util.encrypt(data.getMerchantToken()));
        Call<NICEPayResponseV1> callSync = requestV1.cancelTransaction(ModelUtils.toMap(data));
        NICEPayResponseV1 nicePayResponse = new NICEPayResponseV1();
        Object resClient = null;
        try {
            Response response = callSync.execute();
            nicePayResponse = (NICEPayResponseV1)response.body();
            ResponseBody errorResponse = response.errorBody();
            resClient = nicePayResponse == null ? errorResponse.string() : gson.toJson((Object)nicePayResponse);
            logger.logInfoV1("END CALL V1 CANCEL TRANSACTION REQUEST");
        }
        catch (IOException ex) {
            logger.logErrorV1("IOException during V1 Cancel Transaction Request: " + ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            logger.logErrorV1("Unexpected error during V1 Cancel Transaction Request: " + ex.getMessage());
            ex.printStackTrace();
        }
        JsonObject jsonObject = JsonParser.parseString((String)resClient.toString()).getAsJsonObject();
        logger.logInfoResponseV1("Response Cancel Transaction V1 :" + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject));
        return (S)nicePayResponse;
    }
}

