/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.service.v2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.nicepay.api.v2.CardRequestV2;
import io.github.nicepay.data.model.Card;
import io.github.nicepay.data.response.v2.NICEPayResponseV2;
import io.github.nicepay.service.v2.V2CommonService;
import io.github.nicepay.utils.ApiUtils;
import io.github.nicepay.utils.NICEPay;
import io.github.nicepay.utils.SHA256Util;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class V2CardService
extends V2CommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"[V2 - Card]");

    public static <S> S callV2CardRegistration(Card data, NICEPay config) throws IOException {
        LOGGER.info("\u001b[32m {} \u001b[0m", (Object)"START CALL V2 CARD REGISTRATION");
        Gson gson = new Gson();
        CardRequestV2 request = ApiUtils.createServiceV2(CardRequestV2.class, config);
        data.setMerchantToken(SHA256Util.encrypt(data.getMerchantToken()));
        Call<NICEPayResponseV2> callSync = request.registerCardV2(data);
        Response response = null;
        NICEPayResponseV2 nicePayResponse = null;
        ResponseBody errorResponse = null;
        String resClient = null;
        JsonObject jsonObject = null;
        try {
            response = callSync.execute();
            nicePayResponse = (NICEPayResponseV2)response.body();
            errorResponse = response.errorBody();
            resClient = nicePayResponse == null ? errorResponse.string() : gson.toJson((Object)nicePayResponse);
            jsonObject = JsonParser.parseString((String)resClient.toString()).getAsJsonObject();
            LOGGER.info("\u001b[35m {} \u001b[0m", (Object)("Response register card transaction :" + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject)));
            LOGGER.info("\u001b[32m {} \u001b[0m", (Object)"END CALL V2 CARD REGISTRATION");
        }
        catch (Exception ex) {
            LOGGER.error("\u001b[31m {} \u001b[0m", (Object)"Card transaction registration failed :");
            ex.printStackTrace();
        }
        return (S)nicePayResponse;
    }

    public static <S> S callV2CardPaymentRequest(Card data, NICEPay config) throws IOException {
        LOGGER.info("\u001b[32m {} \u001b[0m", (Object)"START CALL V2 CARD PAYMENT REQUEST");
        Gson gson = new Gson();
        CardRequestV2 request = ApiUtils.createServiceV2(CardRequestV2.class, config);
        data.setMerchantToken(SHA256Util.encrypt(data.getMerchantToken()));
        Call<ResponseBody> callSync = request.requestPaymentCardV2(data.getTimeStamp(), data.getTXid(), data.getReferenceNo(), data.getMerchantToken(), data.getCardNo(), data.getCardExpYymm(), data.getCardCvv(), data.getCardHolderNm(), data.getCallBackUrl(), data.getRecurringToken(), data.getPreauthToken());
        String resClient = null;
        try {
            Response response = callSync.execute();
            ResponseBody nicePayResponse = (ResponseBody)response.body();
            ResponseBody errorResponse = response.errorBody();
            resClient = nicePayResponse == null ? errorResponse.string() : nicePayResponse.string();
            LOGGER.info("\u001b[35m {} \u001b[0m", (Object)("Response Payment Request :" + resClient));
            LOGGER.info("\u001b[32m {} \u001b[0m", (Object)"END CALL V2 CARD PAYMENT REQUEST");
        }
        catch (Exception ex) {
            LOGGER.error("\u001b[31m {} \u001b[0m", (Object)"Card request payment failed :");
            ex.printStackTrace();
        }
        return (S)resClient;
    }
}

