/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.ArrayList;
import java.util.List;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.MethodCV;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.util.StringUtil;

public class MethodASM
implements IASM,
Opcodes {
    private static List<String> defaultPatterns = new ArrayList<String>();
    private static List<String> defaultExcludePatterns = new ArrayList<String>();
    private Configure conf = Configure.getInstance();
    private List<HookingSet> target;
    private List<HookingSet> excludeTarget;

    public MethodASM() {
        String patterns = this.buildPatterns(this.conf.hook_method_patterns, defaultPatterns);
        String excludPatterns = this.buildPatterns(this.conf.hook_method_exclude_patterns, defaultExcludePatterns);
        this.target = HookingSet.getHookingMethodSet(patterns);
        this.excludeTarget = HookingSet.getHookingMethodSet(excludPatterns);
    }

    public static void addPatterns(String methodPattern) {
        defaultPatterns.add(methodPattern);
    }

    public static void addExcludePatterns(String methodPattern) {
        defaultExcludePatterns.add(methodPattern);
    }

    private String buildPatterns(String patterns, List<String> patternsList) {
        for (int i = 0; i < patternsList.size(); ++i) {
            patterns = StringUtil.isNotEmpty(StringUtil.trim(patterns)) ? patterns + "," + patternsList.get(i) : patternsList.get(i);
        }
        return patterns;
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.conf._hook_methods_enabled) {
            return cv;
        }
        if (this.target.size() == 0) {
            return cv;
        }
        if (this.conf.isIgnoreMethodClass(className)) {
            return cv;
        }
        for (int i = 0; i < this.target.size(); ++i) {
            HookingSet mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new MethodCV(cv, mset, this.excludeTarget, className);
        }
        return cv;
    }
}

