/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.HashMap;
import java.util.Map;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.SocketCV;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class SocketASM
implements IASM,
Opcodes {
    private Map<String, HookingSet> reserved = new HashMap<String, HookingSet>();

    public SocketASM() {
        AsmUtil.add(this.reserved, "java/net/Socket", "connect(Ljava/net/SocketAddress;I)V");
        AsmUtil.add(this.reserved, "sun/nio/ch/SocketChannelImpl", "connect(Ljava/net/SocketAddress;)Z");
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!Configure.getInstance()._hook_socket_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new SocketCV(cv, mset, className);
        }
        return cv;
    }
}

