/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.List;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.UserExceptionCV;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class UserExceptionASM
implements IASM,
Opcodes {
    String exceptionPatterns;
    String exceptionExcludePatterns;
    private List<HookingSet> target;
    private List<HookingSet> excludeTarget;

    public UserExceptionASM() {
        this.exceptionPatterns = HookingSet.classPattrensToMethodPatterns(Configure.getInstance().hook_exception_class_patterns, "<init>");
        this.exceptionExcludePatterns = HookingSet.classPattrensToMethodPatterns(Configure.getInstance().hook_exception_exclude_class_patterns, "<init>");
        this.target = HookingSet.getHookingMethodSet(this.exceptionPatterns);
        this.excludeTarget = HookingSet.getHookingMethodSet(this.exceptionExcludePatterns);
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        for (int i = 0; i < this.target.size(); ++i) {
            HookingSet mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            for (int j = 0; j < this.excludeTarget.size(); ++j) {
                HookingSet excludeHookinSet = this.excludeTarget.get(j);
                if (!excludeHookinSet.classMatch.include(className)) continue;
                return cv;
            }
            return new UserExceptionCV(cv, mset, className);
        }
        return cv;
    }
}

