/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.asyncsupport;

import java.util.ArrayList;
import java.util.List;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.asyncsupport.AsyncContextCV;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class AsyncContextDispatchASM
implements IASM,
Opcodes {
    private static List<String> preservedAsyncContextDispatchPatterns = new ArrayList<String>();
    public static final String ON_COMPLETE_SELF_DISPATCH_METHOD = "dispatch()V";
    private Configure conf = Configure.getInstance();
    private List<HookingSet> dispatchTarget;

    public AsyncContextDispatchASM() {
        this.dispatchTarget = HookingSet.getHookingMethodSet(HookingSet.buildPatterns(this.conf.hook_async_context_dispatch_patterns, preservedAsyncContextDispatchPatterns));
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.conf.hook_async_servlet_enabled) {
            return cv;
        }
        for (int i = 0; i < this.dispatchTarget.size(); ++i) {
            HookingSet mset = this.dispatchTarget.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new AsyncContextCV(cv, mset, className);
        }
        return cv;
    }

    static {
        preservedAsyncContextDispatchPatterns.add("org.apache.catalina.core.AsyncContextImpl.dispatch(Ljavax/servlet/ServletContext;Ljava/lang/String;)V");
    }
}

