/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.meter;

import scouter.agent.Configure;
import scouter.agent.counter.meter.MeterInteraction;
import scouter.util.LinkedMap;
import scouter.util.Pair;
import scouter.util.RequestQueue;
import scouter.util.ThreadUtil;

public class MeterInteractionManager
extends Thread {
    private static MeterInteractionManager instance;
    private static Configure conf;
    private RequestQueue<Pair<String, Key>> queue = new RequestQueue(1024);
    private static LinkedMap<Key, MeterInteraction> apiOutgoingMeterMap;
    private static LinkedMap<Key, MeterInteraction> normalOutgoingMeterMap;
    private static LinkedMap<Key, MeterInteraction> apiIncomingMeterMap;
    private static LinkedMap<Key, MeterInteraction> normalIncomingMeterMap;
    private static LinkedMap<Key, MeterInteraction> dbCallMeterMap;
    private static LinkedMap<Key, MeterInteraction> redisCallMeterMap;
    private static LinkedMap<Key, MeterInteraction> kafkaCallMeterMap;
    private static LinkedMap<Key, MeterInteraction> rabbitmqCallMeterMap;

    private MeterInteractionManager() {
    }

    public static final synchronized MeterInteractionManager getInstance() {
        if (instance == null) {
            instance = new MeterInteractionManager();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    @Override
    public void run() {
        while (true) {
            Pair<String, Key> pair = this.queue.get();
            String type = pair.getLeft();
            Key key = pair.getRight();
            MeterInteraction meterInteraction = new MeterInteraction(type, type + "_" + key.fromHash + "_" + key.toHash);
            if ("INTR_API_OUTGOING".equals(type)) {
                apiOutgoingMeterMap.put(key, meterInteraction);
                continue;
            }
            if ("INTR_NORMAL_OUTGOING".equals(type)) {
                normalOutgoingMeterMap.put(key, meterInteraction);
                continue;
            }
            if ("INTR_API_INCOMING".equals(type)) {
                apiIncomingMeterMap.put(key, meterInteraction);
                continue;
            }
            if ("INTR_NORMAL_INCOMING".equals(type)) {
                normalIncomingMeterMap.put(key, meterInteraction);
                continue;
            }
            if ("INTR_DB_CALL".equals(type)) {
                dbCallMeterMap.put(key, meterInteraction);
                continue;
            }
            if ("INTR_REDIS_CALL".equals(type)) {
                redisCallMeterMap.put(key, meterInteraction);
                continue;
            }
            if ("INTR_KAFKA_CALL".equals(type)) {
                kafkaCallMeterMap.put(key, meterInteraction);
                continue;
            }
            if (!"INTR_RABBITMQ_CALL".equals(type)) continue;
            rabbitmqCallMeterMap.put(key, meterInteraction);
        }
    }

    public MeterInteraction getApiOutgoingMeter(int fromHash, int toHash) {
        Key key = new Key(fromHash, toHash);
        MeterInteraction meter = apiOutgoingMeterMap.get(key);
        if (meter == null) {
            this.queue.put(new Pair<String, Key>("INTR_API_OUTGOING", key));
        }
        return meter;
    }

    public MeterInteraction getNormalOutgoingMeter(int fromHash, int toHash) {
        Key key = new Key(fromHash, toHash);
        MeterInteraction meter = normalOutgoingMeterMap.get(key);
        if (meter == null) {
            this.queue.put(new Pair<String, Key>("INTR_NORMAL_OUTGOING", key));
        }
        return meter;
    }

    public MeterInteraction getApiIncomingMeter(int fromHash, int toHash) {
        Key key = new Key(fromHash, toHash);
        MeterInteraction meter = apiIncomingMeterMap.get(key);
        if (meter == null) {
            this.queue.put(new Pair<String, Key>("INTR_API_INCOMING", key));
        }
        return meter;
    }

    public MeterInteraction getNormalIncomingMeter(int fromHash, int toHash) {
        Key key = new Key(fromHash, toHash);
        MeterInteraction meter = normalIncomingMeterMap.get(key);
        if (meter == null) {
            this.queue.put(new Pair<String, Key>("INTR_NORMAL_INCOMING", key));
        }
        return meter;
    }

    public MeterInteraction getDbCallMeter(int fromHash, int toHash) {
        Key key = new Key(fromHash, toHash);
        MeterInteraction meter = dbCallMeterMap.get(key);
        if (meter == null) {
            this.queue.put(new Pair<String, Key>("INTR_DB_CALL", key));
        }
        return meter;
    }

    public MeterInteraction getRedisCallMeter(int fromHash, int toHash) {
        Key key = new Key(fromHash, toHash);
        MeterInteraction meter = redisCallMeterMap.get(key);
        if (meter == null) {
            this.queue.put(new Pair<String, Key>("INTR_REDIS_CALL", key));
        }
        return meter;
    }

    public MeterInteraction getKafkaCallMeter(int fromHash, int toHash) {
        Key key = new Key(fromHash, toHash);
        MeterInteraction meter = kafkaCallMeterMap.get(key);
        if (meter == null) {
            this.queue.put(new Pair<String, Key>("INTR_KAFKA_CALL", key));
        }
        return meter;
    }

    public MeterInteraction getRabbitmqCallMeter(int fromHash, int toHash) {
        Key key = new Key(fromHash, toHash);
        MeterInteraction meter = rabbitmqCallMeterMap.get(key);
        if (meter == null) {
            this.queue.put(new Pair<String, Key>("INTR_RABBITMQ_CALL", key));
        }
        return meter;
    }

    public LinkedMap<Key, MeterInteraction> getApiOutgoingMeterMap() {
        return apiOutgoingMeterMap;
    }

    public LinkedMap<Key, MeterInteraction> getNormalOutgoingMeterMap() {
        return normalOutgoingMeterMap;
    }

    public LinkedMap<Key, MeterInteraction> getApiIncomingMeterMap() {
        return apiIncomingMeterMap;
    }

    public LinkedMap<Key, MeterInteraction> getNormalIncomingMeterMap() {
        return normalIncomingMeterMap;
    }

    public LinkedMap<Key, MeterInteraction> getDbCallMeterMap() {
        return dbCallMeterMap;
    }

    public LinkedMap<Key, MeterInteraction> getRedisCallMeterMap() {
        return redisCallMeterMap;
    }

    public LinkedMap<Key, MeterInteraction> getKafkaCallMeterMap() {
        return kafkaCallMeterMap;
    }

    public LinkedMap<Key, MeterInteraction> getRabbitmqCallMeterMap() {
        return rabbitmqCallMeterMap;
    }

    static {
        conf = Configure.getInstance();
        apiOutgoingMeterMap = new LinkedMap().setMax(1000);
        normalOutgoingMeterMap = new LinkedMap().setMax(1000);
        apiIncomingMeterMap = new LinkedMap().setMax(1000);
        normalIncomingMeterMap = new LinkedMap().setMax(100);
        dbCallMeterMap = new LinkedMap().setMax(1000);
        redisCallMeterMap = new LinkedMap().setMax(1000);
        kafkaCallMeterMap = new LinkedMap().setMax(1000);
        rabbitmqCallMeterMap = new LinkedMap().setMax(1000);
    }

    public static class Key {
        public int fromHash;
        public int toHash;

        public Key(int fromHash, int toHash) {
            this.fromHash = fromHash;
            this.toHash = toHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.fromHash == key.fromHash && this.toHash == key.toHash;
        }

        public int hashCode() {
            return this.fromHash ^ this.toHash;
        }
    }
}

