/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.task;

import java.util.Enumeration;
import scouter.agent.Configure;
import scouter.agent.counter.InteractionCounterBasket;
import scouter.agent.counter.anotation.InteractionCounter;
import scouter.agent.counter.meter.MeterInteraction;
import scouter.agent.counter.meter.MeterInteractionManager;
import scouter.lang.pack.InteractionPerfCounterPack;
import scouter.util.LinkedMap;

public class InteractionPerf {
    private Configure conf = Configure.getInstance();

    @InteractionCounter(interval=5000)
    public void collectApiIncomingInteractionCounter(InteractionCounterBasket basket) {
        if (!this.conf.counter_interaction_enabled) {
            return;
        }
        int periodSec = 30;
        String interactionType = "INTR_API_INCOMING";
        LinkedMap<MeterInteractionManager.Key, MeterInteraction> apiIncomingMeterMap = MeterInteractionManager.getInstance().getApiIncomingMeterMap();
        this.addInteractionsToBasket(basket, interactionType, apiIncomingMeterMap, periodSec);
    }

    @InteractionCounter(interval=5000)
    public void collectNormalIncomingInteractionCounter(InteractionCounterBasket basket) {
        if (!this.conf.counter_interaction_enabled) {
            return;
        }
        int periodSec = 30;
        String interactionType = "INTR_NORMAL_INCOMING";
        LinkedMap<MeterInteractionManager.Key, MeterInteraction> normalIncomingMeterMap = MeterInteractionManager.getInstance().getNormalIncomingMeterMap();
        this.addInteractionsToBasket(basket, interactionType, normalIncomingMeterMap, periodSec);
    }

    @InteractionCounter(interval=5000)
    public void collectApiOutgoingInteractionCounter(InteractionCounterBasket basket) {
        if (!this.conf.counter_interaction_enabled) {
            return;
        }
        int periodSec = 30;
        String interactionType = "INTR_API_OUTGOING";
        LinkedMap<MeterInteractionManager.Key, MeterInteraction> apiOutgoingMeterMap = MeterInteractionManager.getInstance().getApiOutgoingMeterMap();
        this.addInteractionsToBasket(basket, interactionType, apiOutgoingMeterMap, periodSec);
    }

    @InteractionCounter(interval=5000)
    public void collectNormalOutgoingInteractionCounter(InteractionCounterBasket basket) {
        if (!this.conf.counter_interaction_enabled) {
            return;
        }
        int periodSec = 30;
        String interactionType = "INTR_NORMAL_OUTGOING";
        LinkedMap<MeterInteractionManager.Key, MeterInteraction> normalOutgoingMeterMap = MeterInteractionManager.getInstance().getNormalOutgoingMeterMap();
        this.addInteractionsToBasket(basket, interactionType, normalOutgoingMeterMap, periodSec);
    }

    @InteractionCounter(interval=5000)
    public void collectDbCallInteractionCounter(InteractionCounterBasket basket) {
        if (!this.conf.counter_interaction_enabled) {
            return;
        }
        int periodSec = 30;
        String interactionType = "INTR_DB_CALL";
        LinkedMap<MeterInteractionManager.Key, MeterInteraction> dbCallMeterMap = MeterInteractionManager.getInstance().getDbCallMeterMap();
        this.addInteractionsToBasket(basket, interactionType, dbCallMeterMap, periodSec);
    }

    @InteractionCounter(interval=5000)
    public void collectRedisCallInteractionCounter(InteractionCounterBasket basket) {
        if (!this.conf.counter_interaction_enabled) {
            return;
        }
        int periodSec = 30;
        String interactionType = "INTR_REDIS_CALL";
        LinkedMap<MeterInteractionManager.Key, MeterInteraction> redisCallMeterMap = MeterInteractionManager.getInstance().getRedisCallMeterMap();
        this.addInteractionsToBasket(basket, interactionType, redisCallMeterMap, periodSec);
    }

    @InteractionCounter(interval=5000)
    public void collectKafkaCallInteractionCounter(InteractionCounterBasket basket) {
        if (!this.conf.counter_interaction_enabled) {
            return;
        }
        int periodSec = 30;
        String interactionType = "INTR_KAFKA_CALL";
        LinkedMap<MeterInteractionManager.Key, MeterInteraction> kafkaCallMeterMap = MeterInteractionManager.getInstance().getKafkaCallMeterMap();
        this.addInteractionsToBasket(basket, interactionType, kafkaCallMeterMap, periodSec);
    }

    @InteractionCounter(interval=5000)
    public void collecRabbitmqCallInteractionCounter(InteractionCounterBasket basket) {
        if (!this.conf.counter_interaction_enabled) {
            return;
        }
        int periodSec = 30;
        String interactionType = "INTR_RABBITMQ_CALL";
        LinkedMap<MeterInteractionManager.Key, MeterInteraction> rabbitmqCallMeterMap = MeterInteractionManager.getInstance().getRabbitmqCallMeterMap();
        this.addInteractionsToBasket(basket, interactionType, rabbitmqCallMeterMap, periodSec);
    }

    private void addInteractionsToBasket(InteractionCounterBasket basket, String interactionType, LinkedMap<MeterInteractionManager.Key, MeterInteraction> apiIncomingMeterMap, int periodSec) {
        Enumeration<LinkedMap.LinkedEntry<MeterInteractionManager.Key, MeterInteraction>> entries = apiIncomingMeterMap.entries();
        while (entries.hasMoreElements()) {
            LinkedMap.LinkedEntry<MeterInteractionManager.Key, MeterInteraction> entry = entries.nextElement();
            MeterInteractionManager.Key key = entry.getKey();
            MeterInteraction meterInteraction = entry.getValue();
            InteractionPerfCounterPack pack = new InteractionPerfCounterPack(this.conf.getObjName(), interactionType);
            pack.fromHash = key.fromHash;
            pack.toHash = key.toHash;
            pack.period = periodSec;
            pack.count = meterInteraction.getCount(periodSec);
            pack.errorCount = meterInteraction.getErrorCount(periodSec);
            pack.totalElapsed = meterInteraction.getSumTime(periodSec);
            basket.add(interactionType, pack);
        }
    }
}

