/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.netio.request.handle;

import java.io.File;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import scouter.agent.JavaAgent;
import scouter.agent.Logger;
import scouter.agent.netio.request.anotation.RequestHandler;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BlobValue;
import scouter.lang.value.ListValue;
import scouter.util.ClassUtil;
import scouter.util.FileUtil;

public class AgentClassHandle {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestHandler(value="OBJECT_LOAD_CLASS_BY_STREAM")
    public Pack loadClassAsStream(Pack param) {
        Class clazz;
        InputStream is;
        String className;
        MapPack p;
        block6: {
            p = (MapPack)param;
            className = p.getText("class");
            is = null;
            clazz = this.getClass(className);
            if (clazz != null) break block6;
            p.put("error", "Not found class " + className);
            MapPack mapPack = p;
            FileUtil.close(is);
            return mapPack;
        }
        try {
            String clsAsResource = "/" + className.replace('.', '/').concat(".class");
            is = clazz.getResourceAsStream(clsAsResource);
            p.put("class", new BlobValue(FileUtil.readAll(is)));
        }
        catch (Throwable th) {
            try {
                Logger.println("A126", th);
                p.put("error", th.getMessage());
                MapPack mapPack = p;
                return mapPack;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                FileUtil.close(is);
            }
        }
        FileUtil.close(is);
        return p;
    }

    @RequestHandler(value="OBJECT_CLASS_DESC")
    public Pack getClassInfo(Pack param) {
        MapPack p = (MapPack)param;
        String className = p.getText("class");
        try {
            Class clazz = this.getClass(className);
            if (clazz == null) {
                p.put("error", "Not found class " + className);
                return p;
            }
            p.put("class", ClassUtil.getClassDescription(clazz));
        }
        catch (Throwable th) {
            Logger.println("A904", th);
            p.put("error", th.getMessage());
            return p;
        }
        return p;
    }

    private ListValue toValue(Class[] inf) {
        ListValue v = new ListValue();
        for (int i = 0; i < inf.length; ++i) {
            v.add(inf[i].getName());
        }
        return v;
    }

    private Class getClass(String className) {
        Class[] loadedClasses;
        for (Class c : loadedClasses = JavaAgent.getInstrumentation().getAllLoadedClasses()) {
            if (!c.getName().equals(className)) continue;
            return c;
        }
        return null;
    }

    @RequestHandler(value="OBJECT_CHECK_RESOURCE_FILE")
    public Pack checkJarFile(Pack param) {
        MapPack p = (MapPack)param;
        String resource = p.getText("resource");
        MapPack m = new MapPack();
        try {
            URL url = new URL(resource);
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            File file = new File(connection.getJarFileURL().toURI());
            if (!file.exists()) {
                m.put("error", "Cannot find jar file.");
            } else if (file.canRead()) {
                m.put("name", file.getName());
                m.put("size", file.length());
            } else {
                m.put("error", "Cannot read jar file.");
            }
        }
        catch (Exception e) {
            m.put("error", e.toString());
        }
        return m;
    }

    @RequestHandler(value="OBJECT_DOWNLOAD_JAR")
    public Pack downloadJar(Pack param) {
        MapPack p = (MapPack)param;
        String resource = p.getText("resource");
        MapPack m = new MapPack();
        try {
            URL url = new URL(resource);
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            File file = new File(connection.getJarFileURL().toURI());
            if (!file.exists()) {
                m.put("error", "Cannot find jar file.");
            } else if (file.canRead()) {
                m.put("jar", new BlobValue(FileUtil.readAll(file)));
            } else {
                m.put("error", "Cannot read jar file.");
            }
        }
        catch (Exception e) {
            m.put("error", e.toString());
        }
        return m;
    }
}

