/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.proxy;

import java.io.PrintWriter;
import java.util.List;
import scouter.agent.proxy.IToolsMain;
import scouter.agent.proxy.LoaderManager;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.SystemUtil;
import scouter.util.ThreadUtil;

public class ToolsMainFactory {
    private static final String TOOLS_MAIN = "scouter.xtra.tools.ToolsMain";
    public static boolean activeStack = false;

    public static MapPack heaphisto(Pack param) throws Throwable {
        MapPack m = new MapPack();
        if (SystemUtil.IS_JAVA_1_5) {
            m.put("error", "Not supported java version : " + SystemUtil.JAVA_VERSION);
            return m;
        }
        if (SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            m.put("error", "Not supported java vendor : " + SystemUtil.JAVA_VENDOR);
            return m;
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            return null;
        }
        if (SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            m.put("error", "Not supported java vendor : " + SystemUtil.JAVA_VENDOR);
            return m;
        }
        try {
            Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
            IToolsMain toolsMain = (IToolsMain)c.newInstance();
            List<String> out = toolsMain.heaphisto(0, 100000, "all");
            ListValue lv = m.newList("heaphisto");
            for (int i = 0; i < out.size(); ++i) {
                lv.add(out.get(i));
            }
        }
        catch (Exception e) {
            m.put("error", e.getMessage());
        }
        return m;
    }

    public static void heaphisto(PrintWriter out) throws Throwable {
        if (SystemUtil.IS_JAVA_1_5) {
            return;
        }
        if (SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            return;
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            return;
        }
        try {
            Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
            IToolsMain toolsMain = (IToolsMain)c.newInstance();
            toolsMain.heaphisto(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Pack threadDump(Pack param) throws Throwable {
        MapPack m = new MapPack();
        if (SystemUtil.IS_JAVA_1_5 || SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            List<String> out = ThreadUtil.getThreadDumpList();
            ListValue lv = m.newList("threadDump");
            for (int i = 0; i < out.size(); ++i) {
                lv.add(out.get(i));
            }
            return m;
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            List<String> out = ThreadUtil.getThreadDumpList();
            ListValue lv = m.newList("threadDump");
            for (int i = 0; i < out.size(); ++i) {
                lv.add(out.get(i));
            }
            return m;
        }
        try {
            Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
            IToolsMain toolsMain = (IToolsMain)c.newInstance();
            List<String> out = toolsMain.threadDump(0, 100000);
            ListValue lv = m.newList("threadDump");
            for (int i = 0; i < out.size(); ++i) {
                lv.add(out.get(i));
            }
        }
        catch (Exception e) {
            m.put("error", e.getMessage());
        }
        return m;
    }

    public static synchronized void threadDump(PrintWriter out) throws Throwable {
        activeStack = true;
        if (SystemUtil.IS_JAVA_1_5 || SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            out.print(ThreadUtil.getThreadDump());
            return;
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            out.print(ThreadUtil.getThreadDump());
            return;
        }
        try {
            Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
            IToolsMain toolsMain = (IToolsMain)c.newInstance();
            toolsMain.threadDump(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

