/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace.api;

import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.plugin.PluginHttpCallTrace;
import scouter.agent.proxy.HttpClient43Factory;
import scouter.agent.proxy.IHttpClient;
import scouter.agent.trace.HookArgs;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.api.ApiCallTraceHelper;
import scouter.lang.step.ApiCallStep;
import scouter.util.Hexa32;
import scouter.util.IntKeyLinkedMap;
import scouter.util.KeyGen;

public class ForHttpClient43
implements ApiCallTraceHelper.IHelper {
    private static IntKeyLinkedMap<IHttpClient> httpclients = new IntKeyLinkedMap().setMax(5);
    private static Configure conf = Configure.getInstance();
    private boolean ok = true;

    @Override
    public ApiCallStep process(TraceContext ctx, HookArgs hookPoint) {
        ApiCallStep step = new ApiCallStep();
        if (this.ok) {
            try {
                if (hookPoint.args != null && hookPoint.args.length >= 2) {
                    IHttpClient httpclient = this.getProxy(hookPoint.this1);
                    step.txid = KeyGen.next();
                    this.transfer(httpclient, ctx, hookPoint.args[0], hookPoint.args[1], step.txid);
                    String host = httpclient.getHost(hookPoint.args[0]);
                    step.opt = 1;
                    step.address = host;
                    if (host != null) {
                        ctx.apicall_target = host;
                    }
                    ctx.apicall_name = httpclient.getURI(hookPoint.args[1]);
                }
            }
            catch (Exception e) {
                this.ok = false;
            }
        }
        if (ctx.apicall_name == null) {
            ctx.apicall_name = hookPoint.class1;
        }
        return step;
    }

    @Override
    public void processEnd(TraceContext ctx, ApiCallStep step, Object rtn, HookArgs hookPoint) {
        IHttpClient httpclient = this.getProxy(hookPoint.this1);
        String calleeObjHashStr = httpclient.getResponseHeader(rtn, ForHttpClient43.conf._trace_interservice_callee_obj_header_key);
        if (calleeObjHashStr != null) {
            try {
                ctx.lastCalleeObjHash = Integer.parseInt(calleeObjHashStr);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            ctx.lastCalleeObjHash = 0;
        }
    }

    public void processSetCalleeToCtx(TraceContext ctx, Object _this, Object response) {
        IHttpClient httpclient = this.getProxy(_this);
        String calleeObjHashStr = httpclient.getResponseHeader(response, ForHttpClient43.conf._trace_interservice_callee_obj_header_key);
        if (calleeObjHashStr != null) {
            try {
                ctx.lastCalleeObjHash = Integer.parseInt(calleeObjHashStr);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            ctx.lastCalleeObjHash = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHttpClient getProxy(Object _this) {
        int key = System.identityHashCode(_this.getClass());
        IHttpClient httpclient = httpclients.get(key);
        if (httpclient == null) {
            ForHttpClient43 forHttpClient43 = this;
            synchronized (forHttpClient43) {
                httpclient = HttpClient43Factory.create(_this.getClass().getClassLoader());
                httpclients.put(key, httpclient);
            }
        }
        return httpclient;
    }

    private void transfer(IHttpClient httpclient, TraceContext ctx, Object host, Object req, long calleeTxid) {
        Configure conf = Configure.getInstance();
        if (conf.trace_interservice_enabled) {
            try {
                if (ctx.gxid == 0L) {
                    ctx.gxid = ctx.txid;
                }
                httpclient.addHeader(req, conf._trace_interservice_gxid_header_key, Hexa32.toString32(ctx.gxid));
                httpclient.addHeader(req, conf._trace_interservice_caller_header_key, Hexa32.toString32(ctx.txid));
                httpclient.addHeader(req, conf._trace_interservice_callee_header_key, Hexa32.toString32(calleeTxid));
                httpclient.addHeader(req, conf._trace_interservice_caller_obj_header_key, String.valueOf(conf.getObjHash()));
                httpclient.addHeader(req, "x-b3-traceid", Hexa32.toUnsignedLongHex(ctx.gxid));
                httpclient.addHeader(req, "x-b3-parentspanid", Hexa32.toUnsignedLongHex(ctx.txid));
                httpclient.addHeader(req, "x-b3-spanid", Hexa32.toUnsignedLongHex(calleeTxid));
                PluginHttpCallTrace.call(ctx, req);
            }
            catch (Exception e) {
                Logger.println("A178", e);
                this.ok = false;
            }
        }
    }
}

