/*
 * Decompiled with CFR 0.152.
 */
package scouter.repack.net.bytebuddy.implementation.bytecode.constant;

import scouter.repack.net.bytebuddy.implementation.Implementation;
import scouter.repack.net.bytebuddy.implementation.bytecode.StackManipulation;
import scouter.repack.net.bytebuddy.implementation.bytecode.StackSize;
import scouter.repack.net.bytebuddy.jar.asm.MethodVisitor;

public enum DoubleConstant implements StackManipulation
{
    ZERO(14),
    ONE(15);

    private static final StackManipulation.Size SIZE;
    private final int opcode;

    private DoubleConstant(int opcode) {
        this.opcode = opcode;
    }

    public static StackManipulation forValue(double value) {
        if (value == 0.0) {
            return ZERO;
        }
        if (value == 1.0) {
            return ONE;
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        SIZE = StackSize.DOUBLE.toIncreasingSize();
    }

    protected static class ConstantPool
    implements StackManipulation {
        private final double value;

        protected ConstantPool(double value) {
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn(this.value);
            return SIZE;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstantPool)) {
                return false;
            }
            ConstantPool other = (ConstantPool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Double.compare(this.value, other.value) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConstantPool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $value = Double.doubleToLongBits(this.value);
            result = result * 59 + (int)($value >>> 32 ^ $value);
            return result;
        }
    }
}

