/*
 * Decompiled with CFR 0.152.
 */
package scouter.test;

import java.util.Random;
import scouter.agent.AgentBoot;
import scouter.agent.Configure;
import scouter.agent.netio.data.net.TcpRequestMgr;
import scouter.agent.trace.TraceMain;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.HashUtil;
import scouter.util.KeyGen;
import scouter.util.ShellArg;
import scouter.util.ThreadUtil;

public class ShardMain {
    public static void main(String[] args) {
        ShellArg sh = new ShellArg(args);
        String server = sh.get("-h", "127.0.0.1");
        String port = sh.get("-p", "6101");
        System.setProperty("server.addr", server);
        System.setProperty("server.port", port);
        int tps = CastUtil.cint(sh.get("-t", "10"));
        System.out.println("Scouter Test Simulation!!");
        System.out.println("  server = " + server + ":" + port);
        System.out.println("  tcp = " + tps);
        AgentBoot.boot();
        TcpRequestMgr.getInstance();
        double interval = 1000.0 / (double)tps;
        Random r = new Random();
        long txcount = 0L;
        double tm = 0.0;
        long last_unit = 0L;
        while (true) {
            ++txcount;
            long endtime = System.currentTimeMillis();
            long txid = KeyGen.next();
            String serviceName = "service" + ShardMain.next(r, 10);
            int service_hash = HashUtil.hash(serviceName);
            int elapsed = ShardMain.next(r, 10000);
            int cpu = ShardMain.next(r, 10000);
            int sqlCount = ShardMain.next(r, 100);
            int sqlTime = ShardMain.next(r, 100);
            String remoteAddr = "27.11.11.2";
            String error = null;
            long visitor = KeyGen.next();
            TraceMain.txperf(endtime, txid, service_hash, serviceName, elapsed, cpu, sqlCount, sqlTime, remoteAddr, error, visitor);
            long unit = endtime / 5000L;
            if (last_unit != unit) {
                last_unit = unit;
                System.out.println(DateUtil.timestamp(endtime) + "  exe-tx=" + txcount + "  " + Configure.getInstance().getObjName());
            }
            if (!((tm += interval) > 1.0)) continue;
            ThreadUtil.sleep((int)tm);
            tm -= (double)((int)tm);
        }
    }

    private static int next(Random r, int max) {
        return Math.abs(r.nextInt() % max);
    }
}

