/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.IntEnumer;
import scouter.util.StringEnumer;

public class StringHashCacheMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private ENTRY[] table;
    private ENTRY header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int max;

    public StringHashCacheMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new ENTRY[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new ENTRY(null, 0, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public StringHashCacheMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public String[] keyArray() {
        String[] _keys = new String[this.size()];
        StringEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextString();
        }
        return _keys;
    }

    public synchronized StringEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized IntEnumer values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<ENTRY> myEntries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(int value) {
        ENTRY[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            ENTRY e = tab[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(String key) {
        ENTRY[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ENTRY e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized int get(String key) {
        if (key == null) {
            return 0;
        }
        ENTRY[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ENTRY e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    public synchronized int getFirsValue() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.header.link_next.value;
    }

    public synchronized int getLastValue() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.header.link_prev.value;
    }

    private int hash(String key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        ENTRY[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        ENTRY[] newMap = new ENTRY[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            ENTRY old = oldMap[i];
            while (old != null) {
                ENTRY e = old;
                old = old.next;
                String key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public StringHashCacheMap setMax(int max) {
        this.max = max;
        return this;
    }

    public int put(String key, int value) {
        return this._put(key, value, MODE.LAST);
    }

    public int putLast(String key, int value) {
        return this._put(key, value, MODE.FORCE_LAST);
    }

    public int putFirst(String key, int value) {
        return this._put(key, value, MODE.FORCE_FIRST);
    }

    private synchronized int _put(String key, int value, MODE m) {
        if (key == null) {
            return 0;
        }
        ENTRY[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ENTRY e = tab[index];
        while (e != null) {
            if (e.key == key) {
                int old = e.value;
                e.value = value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    while (this.count >= this.max) {
                        this.removeLast();
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    while (this.count >= this.max) {
                        this.removeFirst();
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new ENTRY(key, value, tab[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return 0;
    }

    public synchronized int remove(String key) {
        if (key == null) {
            return 0;
        }
        ENTRY[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ENTRY e = tab[index];
        ENTRY prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                int oldValue = e.value;
                e.value = 0;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return 0;
    }

    public synchronized int removeFirst() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized int removeLast() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        ENTRY[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<ENTRY> it = this.myEntries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            ENTRY e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<ENTRY> it = this.myEntries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            ENTRY e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(ENTRY link_prev, ENTRY link_next, ENTRY e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(ENTRY e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public static void main(String[] args) {
    }

    private static void print(Object e) {
        System.out.println(e);
    }

    private class Enumer
    implements Enumeration,
    StringEnumer,
    IntEnumer {
        TYPE type;
        ENTRY myEntry;

        Enumer(TYPE type) {
            this.myEntry = ((StringHashCacheMap)StringHashCacheMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return StringHashCacheMap.this.header != this.myEntry && this.myEntry != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                ENTRY e = this.myEntry;
                this.myEntry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public int nextInt() {
            if (this.hasMoreElements()) {
                ENTRY e = this.myEntry;
                this.myEntry = e.link_next;
                return e.value;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public String nextString() {
            if (this.hasMoreElements()) {
                ENTRY e = this.myEntry;
                this.myEntry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    public static class ENTRY {
        String key;
        int value;
        ENTRY next;
        ENTRY link_next;
        ENTRY link_prev;

        protected ENTRY(String key, int value, ENTRY next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new ENTRY(this.key, this.value, this.next == null ? null : (ENTRY)this.next.clone());
        }

        public String getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ENTRY)) {
                return false;
            }
            ENTRY e = (ENTRY)o;
            return e.key == this.key && e.value == this.value;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

