/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.intercom.api.CountItemDeserializer;
import io.intercom.api.CountItemSerializer;
import io.intercom.api.Counts;
import io.intercom.api.CustomAttribute;
import io.intercom.api.CustomAttributeDeserializer;
import io.intercom.api.CustomAttributeSerializer;
import io.intercom.api.Subscription;
import io.intercom.api.TopicDeserializer;
import io.intercom.api.TopicSerializer;

public class MapperSupport {
    public static ObjectMapper objectMapper() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final ObjectMapper INSTANCE = new Holder().configure(new ObjectMapper());

        private Holder() {
        }

        private ObjectMapper configure(ObjectMapper om) {
            return om.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true).configure(SerializationFeature.INDENT_OUTPUT, true).configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false).configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, false).registerModule((Module)this.customAttributeModule());
        }

        private SimpleModule customAttributeModule() {
            SimpleModule customAttributeModule = new SimpleModule("IntercomClientModule", new Version(1, 0, 0, null, "", ""));
            customAttributeModule.addDeserializer(CustomAttribute.class, (JsonDeserializer)new CustomAttributeDeserializer());
            customAttributeModule.addSerializer(CustomAttribute.class, (JsonSerializer)new CustomAttributeSerializer());
            customAttributeModule.addDeserializer(Subscription.Topic.class, (JsonDeserializer)new TopicDeserializer());
            customAttributeModule.addSerializer(Subscription.Topic.class, (JsonSerializer)new TopicSerializer());
            customAttributeModule.addSerializer(Counts.CountItem.class, (JsonSerializer)new CountItemSerializer());
            customAttributeModule.addDeserializer(Counts.CountItem.class, (JsonDeserializer)new CountItemDeserializer());
            return customAttributeModule;
        }
    }
}

