/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.conversations;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.QueryStringMapper;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.errors.BadRequestError;
import com.intercom.api.errors.ForbiddenError;
import com.intercom.api.errors.NotFoundError;
import com.intercom.api.errors.UnauthorizedError;
import com.intercom.api.errors.UnprocessableEntityError;
import com.intercom.api.resources.conversations.requests.AttachContactToConversationRequest;
import com.intercom.api.resources.conversations.requests.AutoAssignConversationRequest;
import com.intercom.api.resources.conversations.requests.ConvertConversationToTicketRequest;
import com.intercom.api.resources.conversations.requests.CreateConversationRequest;
import com.intercom.api.resources.conversations.requests.DeleteConversationRequest;
import com.intercom.api.resources.conversations.requests.DetachContactFromConversationRequest;
import com.intercom.api.resources.conversations.requests.FindConversationRequest;
import com.intercom.api.resources.conversations.requests.ListConversationsRequest;
import com.intercom.api.resources.conversations.requests.ManageConversationPartsRequest;
import com.intercom.api.resources.conversations.requests.ReplyToConversationRequest;
import com.intercom.api.resources.conversations.requests.UpdateConversationRequest;
import com.intercom.api.resources.conversations.types.Conversation;
import com.intercom.api.resources.messages.types.Message;
import com.intercom.api.resources.tickets.types.Ticket;
import com.intercom.api.types.ConversationDeleted;
import com.intercom.api.types.ConversationList;
import com.intercom.api.types.CursorPages;
import com.intercom.api.types.Error;
import com.intercom.api.types.RedactConversationRequest;
import com.intercom.api.types.SearchRequest;
import com.intercom.api.types.StartingAfterPaging;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawConversationsClient {
    protected final ClientOptions clientOptions;

    public AsyncRawConversationsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * You can fetch a list of all conversations.
     * <p>You can optionally request the result page size and the cursor to start after to fetch the result.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IntercomHttpResponse<SyncPagingIterable<Conversation>>> list() {
        return list(ListConversationsRequest.builder().build());
    }

    /**
     * You can fetch a list of all conversations.
     * <p>You can optionally request the result page size and the cursor to start after to fetch the result.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IntercomHttpResponse<SyncPagingIterable<Conversation>>> list(
            ListConversationsRequest request) {
        return list(request, null);
    }

    /**
     * You can fetch a list of all conversations.
     * <p>You can optionally request the result page size and the cursor to start after to fetch the result.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IntercomHttpResponse<SyncPagingIterable<Conversation>>> list(
            ListConversationsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations");
        if (request.getPerPage().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "per_page", request.getPerPage().get(), false);
        }
        if (request.getStartingAfter().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "starting_after", request.getStartingAfter().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<SyncPagingIterable<Conversation>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        ConversationList parsedResponse =
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ConversationList.class);
                        Optional<String> startingAfter = parsedResponse
                                .getPages()
                                .flatMap(CursorPages::getNext)
                                .flatMap(StartingAfterPaging::getStartingAfter);
                        ListConversationsRequest nextRequest = ListConversationsRequest.builder()
                                .from(request)
                                .startingAfter(startingAfter)
                                .build();
                        List<Conversation> result =
                                parsedResponse.getConversations().orElse(Collections.emptyList());
                        future.complete(new IntercomHttpResponse<>(
                                new SyncPagingIterable<Conversation>(
                                        startingAfter.isPresent(), result, parsedResponse, () -> {
                                            try {
                                                return list(nextRequest, requestOptions)
                                                        .get()
                                                        .body();
                                            } catch (InterruptedException | ExecutionException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }),
                                response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can create a conversation that has been initiated by a contact (ie. user or lead).
     * The conversation can be an in-app message only.
     * <p>{% admonition type=&quot;info&quot; name=&quot;Sending for visitors&quot; %}
     * You can also send a message from a visitor by specifying their <code>user_id</code> or <code>id</code> value in the <code>from</code> field, along with a <code>type</code> field value of <code>contact</code>.
     * This visitor will be automatically converted to a contact with a lead role once the conversation is created.
     * {% /admonition %}</p>
     * <p>This will return the Message model that has been created.</p>
     */
    public CompletableFuture<IntercomHttpResponse<Message>> create(CreateConversationRequest request) {
        return create(request, null);
    }

    /**
     * You can create a conversation that has been initiated by a contact (ie. user or lead).
     * The conversation can be an in-app message only.
     * <p>{% admonition type=&quot;info&quot; name=&quot;Sending for visitors&quot; %}
     * You can also send a message from a visitor by specifying their <code>user_id</code> or <code>id</code> value in the <code>from</code> field, along with a <code>type</code> field value of <code>contact</code>.
     * This visitor will be automatically converted to a contact with a lead role once the conversation is created.
     * {% /admonition %}</p>
     * <p>This will return the Message model that has been created.</p>
     */
    public CompletableFuture<IntercomHttpResponse<Message>> create(
            CreateConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Message>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Message.class), response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can fetch the details of a single conversation.
     * <p>This will return a single Conversation model with all its conversation parts.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Hard limit of 500 parts&quot; %}
     * The maximum number of conversation parts that can be returned via the API is 500. If you have more than that we will return the 500 most recent conversation parts.
     * {% /admonition %}</p>
     * <p>For AI agent conversation metadata, please note that you need to have the agent enabled in your workspace, which is a <a href="https://www.intercom.com/help/en/articles/8205718-fin-resolutions#h_97f8c2e671">paid feature</a>.</p>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> find(FindConversationRequest request) {
        return find(request, null);
    }

    /**
     * You can fetch the details of a single conversation.
     * <p>This will return a single Conversation model with all its conversation parts.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Hard limit of 500 parts&quot; %}
     * The maximum number of conversation parts that can be returned via the API is 500. If you have more than that we will return the 500 most recent conversation parts.
     * {% /admonition %}</p>
     * <p>For AI agent conversation metadata, please note that you need to have the agent enabled in your workspace, which is a <a href="https://www.intercom.com/help/en/articles/8205718-fin-resolutions#h_97f8c2e671">paid feature</a>.</p>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> find(
            FindConversationRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(request.getConversationId());
        if (request.getDisplayAs().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "display_as", request.getDisplayAs().get(), false);
        }
        if (request.getIncludeTranslations().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "include_translations",
                    request.getIncludeTranslations().get(),
                    false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Conversation>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Conversation.class), response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can update an existing conversation.
     * <p>{% admonition type=&quot;info&quot; name=&quot;Replying and other actions&quot; %}
     * If you want to reply to a coveration or take an action such as assign, unassign, open, close or snooze, take a look at the reply and manage endpoints.
     * {% /admonition %}</p>
     * <p>{% admonition type=&quot;info&quot; %}
     * This endpoint handles both <strong>conversation updates</strong> and <strong>custom object associations</strong>.</p>
     * <p>See <em><code>update a conversation with an association to a custom object instance</code></em> in the request/response examples to see the custom object association format.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> update(UpdateConversationRequest request) {
        return update(request, null);
    }

    /**
     * You can update an existing conversation.
     * <p>{% admonition type=&quot;info&quot; name=&quot;Replying and other actions&quot; %}
     * If you want to reply to a coveration or take an action such as assign, unassign, open, close or snooze, take a look at the reply and manage endpoints.
     * {% /admonition %}</p>
     * <p>{% admonition type=&quot;info&quot; %}
     * This endpoint handles both <strong>conversation updates</strong> and <strong>custom object associations</strong>.</p>
     * <p>See <em><code>update a conversation with an association to a custom object instance</code></em> in the request/response examples to see the custom object association format.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> update(
            UpdateConversationRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(request.getConversationId());
        if (request.getDisplayAs().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "display_as", request.getDisplayAs().get(), false);
        }
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("PUT", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Conversation>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Conversation.class), response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can delete a single conversation.
     */
    public CompletableFuture<IntercomHttpResponse<ConversationDeleted>> deleteConversation(
            DeleteConversationRequest request) {
        return deleteConversation(request, null);
    }

    /**
     * You can delete a single conversation.
     */
    public CompletableFuture<IntercomHttpResponse<ConversationDeleted>> deleteConversation(
            DeleteConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(Integer.toString(request.getConversationId()))
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<ConversationDeleted>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ConversationDeleted.class),
                                response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can search for multiple conversations by the value of their attributes in order to fetch exactly which ones you want.
     * <p>To search for conversations, you need to send a <code>POST</code> request to <code>https://api.intercom.io/conversations/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters in order to search for conversations.
     * {% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>20</code> results per page and maximum is <code>150</code>.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiple's there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Accepted Fields</h3>
     * <p>Most keys listed in the conversation model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foorbar&quot;</code>).
     * The <code>source.body</code> field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a <code>&quot;I need support&quot;</code> body - the query should contain a <code>=</code> operator with the value <code>&quot;support&quot;</code> for such conversation to be returned. A query with a <code>=</code> operator and a <code>&quot;need support&quot;</code> value will not yield a result.</p>
     * <p>| Field                                     | Type                                                                                                                                                   |
     * | :---------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | id                                        | String                                                                                                                                                 |
     * | created_at                                | Date (UNIX timestamp)                                                                                                                                  |
     * | updated_at                                | Date (UNIX timestamp)                                                                                                                                  |
     * | source.type                               | String&lt;br&gt;Accepted fields are <code>conversation</code>, <code>email</code>, <code>facebook</code>, <code>instagram</code>, <code>phone_call</code>, <code>phone_switch</code>, <code>push</code>, <code>sms</code>, <code>twitter</code> and <code>whatsapp</code>. |
     * | source.id                                 | String                                                                                                                                                 |
     * | source.delivered_as                       | String                                                                                                                                                 |
     * | source.subject                            | String                                                                                                                                                 |
     * | source.body                               | String                                                                                                                                                 |
     * | source.author.id                          | String                                                                                                                                                 |
     * | source.author.type                        | String                                                                                                                                                 |
     * | source.author.name                        | String                                                                                                                                                 |
     * | source.author.email                       | String                                                                                                                                                 |
     * | source.url                                | String                                                                                                                                                 |
     * | contact_ids                               | String                                                                                                                                                 |
     * | teammate_ids                              | String                                                                                                                                                 |
     * | admin_assignee_id                         | String                                                                                                                                                 |
     * | team_assignee_id                          | String                                                                                                                                                 |
     * | channel_initiated                         | String                                                                                                                                                 |
     * | open                                      | Boolean                                                                                                                                                |
     * | read                                      | Boolean                                                                                                                                                |
     * | state                                     | String                                                                                                                                                 |
     * | waiting_since                             | Date (UNIX timestamp)                                                                                                                                  |
     * | snoozed_until                             | Date (UNIX timestamp)                                                                                                                                  |
     * | tag_ids                                   | String                                                                                                                                                 |
     * | priority                                  | String                                                                                                                                                 |
     * | statistics.time_to_assignment             | Integer                                                                                                                                                |
     * | statistics.time_to_admin_reply            | Integer                                                                                                                                                |
     * | statistics.time_to_first_close            | Integer                                                                                                                                                |
     * | statistics.time_to_last_close             | Integer                                                                                                                                                |
     * | statistics.median_time_to_reply           | Integer                                                                                                                                                |
     * | statistics.first_contact_reply_at         | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_assignment_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_admin_reply_at           | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_close_at                 | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_assignment_at             | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_assignment_admin_reply_at | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_contact_reply_at          | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_admin_reply_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_close_at                  | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_closed_by_id              | String                                                                                                                                                 |
     * | statistics.count_reopens                  | Integer                                                                                                                                                |
     * | statistics.count_assignments              | Integer                                                                                                                                                |
     * | statistics.count_conversation_parts       | Integer                                                                                                                                                |
     * | conversation_rating.requested_at          | Date (UNIX timestamp)                                                                                                                                  |
     * | conversation_rating.replied_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | conversation_rating.score                 | Integer                                                                                                                                                |
     * | conversation_rating.remark                | String                                                                                                                                                 |
     * | conversation_rating.contact_id            | String                                                                                                                                                 |
     * | conversation_rating.admin_d               | String                                                                                                                                                 |
     * | ai_agent_participated                     | Boolean                                                                                                                                                |
     * | ai_agent.resolution_state                 | String                                                                                                                                                 |
     * | ai_agent.last_answer_type                 | String                                                                                                                                                 |
     * | ai_agent.rating                           | Integer                                                                                                                                                |
     * | ai_agent.rating_remark                    | String                                                                                                                                                 |
     * | ai_agent.source_type                      | String                                                                                                                                                 |
     * | ai_agent.source_title                     | String                                                                                                                                                 |</p>
     * <h3>Accepted Operators</h3>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type  (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                    | Description                                                  |
     * | :------- | :----------------------------- | :----------------------------------------------------------- |
     * | =        | All                            | Equals                                                       |
     * | !=       | All                            | Doesn't Equal                                                |
     * | IN       | All                            | In  Shortcut for <code>OR</code> queries  Values most be in Array       |
     * | NIN      | All                            | Not In  Shortcut for <code>OR !</code> queries  Values must be in Array |
     * | &gt;        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
     * | &lt;       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
     * | ~        | String                         | Contains                                                     |
     * | !~       | String                         | Doesn't Contain                                              |
     * | ^        | String                         | Starts With                                                  |
     * | $        | String                         | Ends With                                                    |</p>
     */
    public CompletableFuture<IntercomHttpResponse<SyncPagingIterable<Conversation>>> search(SearchRequest request) {
        return search(request, null);
    }

    /**
     * You can search for multiple conversations by the value of their attributes in order to fetch exactly which ones you want.
     * <p>To search for conversations, you need to send a <code>POST</code> request to <code>https://api.intercom.io/conversations/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters in order to search for conversations.
     * {% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>20</code> results per page and maximum is <code>150</code>.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiple's there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Accepted Fields</h3>
     * <p>Most keys listed in the conversation model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foorbar&quot;</code>).
     * The <code>source.body</code> field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a <code>&quot;I need support&quot;</code> body - the query should contain a <code>=</code> operator with the value <code>&quot;support&quot;</code> for such conversation to be returned. A query with a <code>=</code> operator and a <code>&quot;need support&quot;</code> value will not yield a result.</p>
     * <p>| Field                                     | Type                                                                                                                                                   |
     * | :---------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | id                                        | String                                                                                                                                                 |
     * | created_at                                | Date (UNIX timestamp)                                                                                                                                  |
     * | updated_at                                | Date (UNIX timestamp)                                                                                                                                  |
     * | source.type                               | String&lt;br&gt;Accepted fields are <code>conversation</code>, <code>email</code>, <code>facebook</code>, <code>instagram</code>, <code>phone_call</code>, <code>phone_switch</code>, <code>push</code>, <code>sms</code>, <code>twitter</code> and <code>whatsapp</code>. |
     * | source.id                                 | String                                                                                                                                                 |
     * | source.delivered_as                       | String                                                                                                                                                 |
     * | source.subject                            | String                                                                                                                                                 |
     * | source.body                               | String                                                                                                                                                 |
     * | source.author.id                          | String                                                                                                                                                 |
     * | source.author.type                        | String                                                                                                                                                 |
     * | source.author.name                        | String                                                                                                                                                 |
     * | source.author.email                       | String                                                                                                                                                 |
     * | source.url                                | String                                                                                                                                                 |
     * | contact_ids                               | String                                                                                                                                                 |
     * | teammate_ids                              | String                                                                                                                                                 |
     * | admin_assignee_id                         | String                                                                                                                                                 |
     * | team_assignee_id                          | String                                                                                                                                                 |
     * | channel_initiated                         | String                                                                                                                                                 |
     * | open                                      | Boolean                                                                                                                                                |
     * | read                                      | Boolean                                                                                                                                                |
     * | state                                     | String                                                                                                                                                 |
     * | waiting_since                             | Date (UNIX timestamp)                                                                                                                                  |
     * | snoozed_until                             | Date (UNIX timestamp)                                                                                                                                  |
     * | tag_ids                                   | String                                                                                                                                                 |
     * | priority                                  | String                                                                                                                                                 |
     * | statistics.time_to_assignment             | Integer                                                                                                                                                |
     * | statistics.time_to_admin_reply            | Integer                                                                                                                                                |
     * | statistics.time_to_first_close            | Integer                                                                                                                                                |
     * | statistics.time_to_last_close             | Integer                                                                                                                                                |
     * | statistics.median_time_to_reply           | Integer                                                                                                                                                |
     * | statistics.first_contact_reply_at         | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_assignment_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_admin_reply_at           | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_close_at                 | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_assignment_at             | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_assignment_admin_reply_at | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_contact_reply_at          | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_admin_reply_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_close_at                  | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_closed_by_id              | String                                                                                                                                                 |
     * | statistics.count_reopens                  | Integer                                                                                                                                                |
     * | statistics.count_assignments              | Integer                                                                                                                                                |
     * | statistics.count_conversation_parts       | Integer                                                                                                                                                |
     * | conversation_rating.requested_at          | Date (UNIX timestamp)                                                                                                                                  |
     * | conversation_rating.replied_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | conversation_rating.score                 | Integer                                                                                                                                                |
     * | conversation_rating.remark                | String                                                                                                                                                 |
     * | conversation_rating.contact_id            | String                                                                                                                                                 |
     * | conversation_rating.admin_d               | String                                                                                                                                                 |
     * | ai_agent_participated                     | Boolean                                                                                                                                                |
     * | ai_agent.resolution_state                 | String                                                                                                                                                 |
     * | ai_agent.last_answer_type                 | String                                                                                                                                                 |
     * | ai_agent.rating                           | Integer                                                                                                                                                |
     * | ai_agent.rating_remark                    | String                                                                                                                                                 |
     * | ai_agent.source_type                      | String                                                                                                                                                 |
     * | ai_agent.source_title                     | String                                                                                                                                                 |</p>
     * <h3>Accepted Operators</h3>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type  (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                    | Description                                                  |
     * | :------- | :----------------------------- | :----------------------------------------------------------- |
     * | =        | All                            | Equals                                                       |
     * | !=       | All                            | Doesn't Equal                                                |
     * | IN       | All                            | In  Shortcut for <code>OR</code> queries  Values most be in Array       |
     * | NIN      | All                            | Not In  Shortcut for <code>OR !</code> queries  Values must be in Array |
     * | &gt;        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
     * | &lt;       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
     * | ~        | String                         | Contains                                                     |
     * | !~       | String                         | Doesn't Contain                                              |
     * | ^        | String                         | Starts With                                                  |
     * | $        | String                         | Ends With                                                    |</p>
     */
    public CompletableFuture<IntercomHttpResponse<SyncPagingIterable<Conversation>>> search(
            SearchRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations/search")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<SyncPagingIterable<Conversation>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        ConversationList parsedResponse =
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ConversationList.class);
                        Optional<String> startingAfter = parsedResponse
                                .getPages()
                                .flatMap(CursorPages::getNext)
                                .flatMap(StartingAfterPaging::getStartingAfter);
                        Optional<StartingAfterPaging> pagination = request.getPagination()
                                .map((StartingAfterPaging pagination_) -> StartingAfterPaging.builder()
                                        .from(pagination_)
                                        .startingAfter(startingAfter)
                                        .build());
                        SearchRequest nextRequest = SearchRequest.builder()
                                .from(request)
                                .pagination(pagination)
                                .build();
                        List<Conversation> result =
                                parsedResponse.getConversations().orElse(Collections.emptyList());
                        future.complete(new IntercomHttpResponse<>(
                                new SyncPagingIterable<Conversation>(
                                        startingAfter.isPresent(), result, parsedResponse, () -> {
                                            try {
                                                return search(nextRequest, requestOptions)
                                                        .get()
                                                        .body();
                                            } catch (InterruptedException | ExecutionException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }),
                                response));
                        return;
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can reply to a conversation with a message from an admin or on behalf of a contact, or with a note for admins.
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> reply(ReplyToConversationRequest request) {
        return reply(request, null);
    }

    /**
     * You can reply to a conversation with a message from an admin or on behalf of a contact, or with a note for admins.
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> reply(
            ReplyToConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(request.getConversationId())
                .addPathSegments("reply")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Conversation>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Conversation.class), response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * For managing conversations you can:
     * <ul>
     * <li>Close a conversation</li>
     * <li>Snooze a conversation to reopen on a future date</li>
     * <li>Open a conversation which is <code>snoozed</code> or <code>closed</code></li>
     * <li>Assign a conversation to an admin and/or team.</li>
     * </ul>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> manage(ManageConversationPartsRequest request) {
        return manage(request, null);
    }

    /**
     * For managing conversations you can:
     * <ul>
     * <li>Close a conversation</li>
     * <li>Snooze a conversation to reopen on a future date</li>
     * <li>Open a conversation which is <code>snoozed</code> or <code>closed</code></li>
     * <li>Assign a conversation to an admin and/or team.</li>
     * </ul>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> manage(
            ManageConversationPartsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(request.getConversationId())
                .addPathSegments("parts")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Conversation>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Conversation.class), response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Contacts without an email&quot; %}
     * If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with <code>role</code> set to <code>lead</code>.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> attachContactAsAdmin(
            AttachContactToConversationRequest request) {
        return attachContactAsAdmin(request, null);
    }

    /**
     * You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Contacts without an email&quot; %}
     * If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with <code>role</code> set to <code>lead</code>.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> attachContactAsAdmin(
            AttachContactToConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(request.getConversationId())
                .addPathSegments("customers")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Conversation>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Conversation.class), response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Contacts without an email&quot; %}
     * If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with <code>role</code> set to <code>lead</code>.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> detachContactAsAdmin(
            DetachContactFromConversationRequest request) {
        return detachContactAsAdmin(request, null);
    }

    /**
     * You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Contacts without an email&quot; %}
     * If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with <code>role</code> set to <code>lead</code>.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> detachContactAsAdmin(
            DetachContactFromConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(request.getConversationId())
                .addPathSegments("customers")
                .addPathSegment(request.getContactId())
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Conversation>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Conversation.class), response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                            case 422:
                                future.completeExceptionally(new UnprocessableEntityError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can redact a conversation part or the source message of a conversation (as seen in the source object).
     * <p>{% admonition type=&quot;info&quot; name=&quot;Redacting parts and messages&quot; %}
     * If you are redacting a conversation part, it must have a <code>body</code>. If you are redacting a source message, it must have been created by a contact. We will return a <code>conversation_part_not_redactable</code> error if these criteria are not met.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> redactConversationPart(
            RedactConversationRequest request) {
        return redactConversationPart(request, null);
    }

    /**
     * You can redact a conversation part or the source message of a conversation (as seen in the source object).
     * <p>{% admonition type=&quot;info&quot; name=&quot;Redacting parts and messages&quot; %}
     * If you are redacting a conversation part, it must have a <code>body</code>. If you are redacting a source message, it must have been created by a contact. We will return a <code>conversation_part_not_redactable</code> error if these criteria are not met.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> redactConversationPart(
            RedactConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations/redact")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Conversation>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Conversation.class), response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can convert a conversation to a ticket.
     */
    public CompletableFuture<IntercomHttpResponse<Optional<Ticket>>> convertToTicket(
            ConvertConversationToTicketRequest request) {
        return convertToTicket(request, null);
    }

    /**
     * You can convert a conversation to a ticket.
     */
    public CompletableFuture<IntercomHttpResponse<Optional<Ticket>>> convertToTicket(
            ConvertConversationToTicketRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(Integer.toString(request.getConversationId()))
                .addPathSegments("convert")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Optional<Ticket>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, new TypeReference<Optional<Ticket>>() {}),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 400) {
                            future.completeExceptionally(new BadRequestError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * {% admonition type=&quot;danger&quot; name=&quot;Deprecation of Run Assignment Rules&quot; %}
     * Run assignment rules is now deprecated in version 2.12 and future versions and will be permanently removed on December 31, 2026. After this date, any requests made to this endpoint will fail.
     * {% /admonition %}
     * You can let a conversation be automatically assigned following assignment rules.
     * {% admonition type=&quot;warning&quot; name=&quot;When using workflows&quot; %}
     * It is not possible to use this endpoint with Workflows.
     * {% /admonition %}
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> runAssignmentRules(
            AutoAssignConversationRequest request) {
        return runAssignmentRules(request, null);
    }

    /**
     * {% admonition type=&quot;danger&quot; name=&quot;Deprecation of Run Assignment Rules&quot; %}
     * Run assignment rules is now deprecated in version 2.12 and future versions and will be permanently removed on December 31, 2026. After this date, any requests made to this endpoint will fail.
     * {% /admonition %}
     * You can let a conversation be automatically assigned following assignment rules.
     * {% admonition type=&quot;warning&quot; name=&quot;When using workflows&quot; %}
     * It is not possible to use this endpoint with Workflows.
     * {% /admonition %}
     */
    public CompletableFuture<IntercomHttpResponse<Conversation>> runAssignmentRules(
            AutoAssignConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(request.getConversationId())
                .addPathSegments("run_assignment_rules")
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Conversation>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Conversation.class), response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 404:
                                future.completeExceptionally(new NotFoundError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
