/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.dataexport.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DownloadReportingDataExportRequest.Builder.class)
public final class DownloadReportingDataExportRequest {
    private final String jobIdentifier;

    private final String appId;

    private final Map<String, Object> additionalProperties;

    private DownloadReportingDataExportRequest(
            String jobIdentifier, String appId, Map<String, Object> additionalProperties) {
        this.jobIdentifier = jobIdentifier;
        this.appId = appId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("job_identifier")
    public String getJobIdentifier() {
        return jobIdentifier;
    }

    /**
     * @return Required header for downloading the export file
     */
    @JsonIgnore
    public String getAccept() {
        return "application/octet-stream";
    }

    @JsonProperty("app_id")
    public String getAppId() {
        return appId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DownloadReportingDataExportRequest
                && equalTo((DownloadReportingDataExportRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DownloadReportingDataExportRequest other) {
        return jobIdentifier.equals(other.jobIdentifier) && appId.equals(other.appId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.jobIdentifier, this.appId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static JobIdentifierStage builder() {
        return new Builder();
    }

    public interface JobIdentifierStage {
        AppIdStage jobIdentifier(@NotNull String jobIdentifier);

        Builder from(DownloadReportingDataExportRequest other);
    }

    public interface AppIdStage {
        _FinalStage appId(@NotNull String appId);
    }

    public interface _FinalStage {
        DownloadReportingDataExportRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements JobIdentifierStage, AppIdStage, _FinalStage {
        private String jobIdentifier;

        private String appId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DownloadReportingDataExportRequest other) {
            jobIdentifier(other.getJobIdentifier());
            appId(other.getAppId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("job_identifier")
        public AppIdStage jobIdentifier(@NotNull String jobIdentifier) {
            this.jobIdentifier = Objects.requireNonNull(jobIdentifier, "jobIdentifier must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("app_id")
        public _FinalStage appId(@NotNull String appId) {
            this.appId = Objects.requireNonNull(appId, "appId must not be null");
            return this;
        }

        @java.lang.Override
        public DownloadReportingDataExportRequest build() {
            return new DownloadReportingDataExportRequest(jobIdentifier, appId, additionalProperties);
        }
    }
}
