/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.internalarticles;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.internalarticles.requests.DeleteInternalArticleRequest;
import com.intercom.api.resources.internalarticles.requests.RetrieveInternalArticleRequest;
import com.intercom.api.resources.internalarticles.requests.SearchInternalArticlesRequest;
import com.intercom.api.resources.internalarticles.requests.UpdateInternalArticleRequestBody;
import com.intercom.api.resources.internalarticles.types.InternalArticleListItem;
import com.intercom.api.resources.internalarticles.types.InternalArticleSearchResponse;
import com.intercom.api.types.CreateInternalArticleRequest;
import com.intercom.api.types.DeletedInternalArticleObject;
import com.intercom.api.types.InternalArticleList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncInternalArticlesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawInternalArticlesClient rawClient;

    public AsyncInternalArticlesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawInternalArticlesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawInternalArticlesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all internal articles by making a GET request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public CompletableFuture<InternalArticleList> listInternalArticles() {
        return this.rawClient.listInternalArticles().thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all internal articles by making a GET request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public CompletableFuture<InternalArticleList> listInternalArticles(RequestOptions requestOptions) {
        return this.rawClient.listInternalArticles(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can create a new internal article by making a POST request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public CompletableFuture<InternalArticleListItem> createInternalArticle() {
        return this.rawClient.createInternalArticle().thenApply(response -> response.body());
    }

    /**
     * You can create a new internal article by making a POST request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public CompletableFuture<InternalArticleListItem> createInternalArticle(
            Optional<CreateInternalArticleRequest> request) {
        return this.rawClient.createInternalArticle(request).thenApply(response -> response.body());
    }

    /**
     * You can create a new internal article by making a POST request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public CompletableFuture<InternalArticleListItem> createInternalArticle(
            Optional<CreateInternalArticleRequest> request, RequestOptions requestOptions) {
        return this.rawClient.createInternalArticle(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single internal article by making a GET request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<InternalArticleListItem> retrieveInternalArticle(RetrieveInternalArticleRequest request) {
        return this.rawClient.retrieveInternalArticle(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single internal article by making a GET request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<InternalArticleListItem> retrieveInternalArticle(
            RetrieveInternalArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveInternalArticle(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can update the details of a single internal article by making a PUT request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<InternalArticleListItem> updateInternalArticle(UpdateInternalArticleRequestBody request) {
        return this.rawClient.updateInternalArticle(request).thenApply(response -> response.body());
    }

    /**
     * You can update the details of a single internal article by making a PUT request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<InternalArticleListItem> updateInternalArticle(
            UpdateInternalArticleRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateInternalArticle(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can delete a single internal article by making a DELETE request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<DeletedInternalArticleObject> deleteInternalArticle(DeleteInternalArticleRequest request) {
        return this.rawClient.deleteInternalArticle(request).thenApply(response -> response.body());
    }

    /**
     * You can delete a single internal article by making a DELETE request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<DeletedInternalArticleObject> deleteInternalArticle(
            DeleteInternalArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteInternalArticle(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can search for internal articles by making a GET request to <code>https://api.intercom.io/internal_articles/search</code>.
     */
    public CompletableFuture<InternalArticleSearchResponse> searchInternalArticles() {
        return this.rawClient.searchInternalArticles().thenApply(response -> response.body());
    }

    /**
     * You can search for internal articles by making a GET request to <code>https://api.intercom.io/internal_articles/search</code>.
     */
    public CompletableFuture<InternalArticleSearchResponse> searchInternalArticles(
            SearchInternalArticlesRequest request) {
        return this.rawClient.searchInternalArticles(request).thenApply(response -> response.body());
    }

    /**
     * You can search for internal articles by making a GET request to <code>https://api.intercom.io/internal_articles/search</code>.
     */
    public CompletableFuture<InternalArticleSearchResponse> searchInternalArticles(
            SearchInternalArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchInternalArticles(request, requestOptions).thenApply(response -> response.body());
    }
}
