/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.emails.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = EmailSetting.Builder.class)
public final class EmailSetting {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> email;

    private final Optional<Boolean> verified;

    private final Optional<String> domain;

    private final Optional<String> brandId;

    private final Optional<Boolean> forwardingEnabled;

    private final Optional<Integer> forwardedEmailLastReceivedAt;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Map<String, Object> additionalProperties;

    private EmailSetting(
            Optional<String> type,
            Optional<String> id,
            Optional<String> email,
            Optional<Boolean> verified,
            Optional<String> domain,
            Optional<String> brandId,
            Optional<Boolean> forwardingEnabled,
            Optional<Integer> forwardedEmailLastReceivedAt,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.email = email;
        this.verified = verified;
        this.domain = domain;
        this.brandId = brandId;
        this.forwardingEnabled = forwardingEnabled;
        this.forwardedEmailLastReceivedAt = forwardedEmailLastReceivedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return Unique email setting identifier
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return Full sender email address
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    /**
     * @return Whether the email address has been verified
     */
    @JsonProperty("verified")
    public Optional<Boolean> getVerified() {
        return verified;
    }

    /**
     * @return Domain portion of the email address
     */
    @JsonProperty("domain")
    public Optional<String> getDomain() {
        return domain;
    }

    /**
     * @return Associated brand identifier
     */
    @JsonProperty("brand_id")
    public Optional<String> getBrandId() {
        return brandId;
    }

    /**
     * @return Whether email forwarding is active
     */
    @JsonProperty("forwarding_enabled")
    public Optional<Boolean> getForwardingEnabled() {
        return forwardingEnabled;
    }

    /**
     * @return Unix timestamp of last forwarded email received (null if never)
     */
    @JsonProperty("forwarded_email_last_received_at")
    public Optional<Integer> getForwardedEmailLastReceivedAt() {
        return forwardedEmailLastReceivedAt;
    }

    /**
     * @return Unix timestamp of creation
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return Unix timestamp of last modification
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof EmailSetting && equalTo((EmailSetting) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EmailSetting other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && email.equals(other.email)
                && verified.equals(other.verified)
                && domain.equals(other.domain)
                && brandId.equals(other.brandId)
                && forwardingEnabled.equals(other.forwardingEnabled)
                && forwardedEmailLastReceivedAt.equals(other.forwardedEmailLastReceivedAt)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.email,
                this.verified,
                this.domain,
                this.brandId,
                this.forwardingEnabled,
                this.forwardedEmailLastReceivedAt,
                this.createdAt,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<Boolean> verified = Optional.empty();

        private Optional<String> domain = Optional.empty();

        private Optional<String> brandId = Optional.empty();

        private Optional<Boolean> forwardingEnabled = Optional.empty();

        private Optional<Integer> forwardedEmailLastReceivedAt = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(EmailSetting other) {
            type(other.getType());
            id(other.getId());
            email(other.getEmail());
            verified(other.getVerified());
            domain(other.getDomain());
            brandId(other.getBrandId());
            forwardingEnabled(other.getForwardingEnabled());
            forwardedEmailLastReceivedAt(other.getForwardedEmailLastReceivedAt());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        /**
         * <p>The type of object</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>Unique email setting identifier</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>Full sender email address</p>
         */
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>Whether the email address has been verified</p>
         */
        @JsonSetter(value = "verified", nulls = Nulls.SKIP)
        public Builder verified(Optional<Boolean> verified) {
            this.verified = verified;
            return this;
        }

        public Builder verified(Boolean verified) {
            this.verified = Optional.ofNullable(verified);
            return this;
        }

        /**
         * <p>Domain portion of the email address</p>
         */
        @JsonSetter(value = "domain", nulls = Nulls.SKIP)
        public Builder domain(Optional<String> domain) {
            this.domain = domain;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = Optional.ofNullable(domain);
            return this;
        }

        /**
         * <p>Associated brand identifier</p>
         */
        @JsonSetter(value = "brand_id", nulls = Nulls.SKIP)
        public Builder brandId(Optional<String> brandId) {
            this.brandId = brandId;
            return this;
        }

        public Builder brandId(String brandId) {
            this.brandId = Optional.ofNullable(brandId);
            return this;
        }

        /**
         * <p>Whether email forwarding is active</p>
         */
        @JsonSetter(value = "forwarding_enabled", nulls = Nulls.SKIP)
        public Builder forwardingEnabled(Optional<Boolean> forwardingEnabled) {
            this.forwardingEnabled = forwardingEnabled;
            return this;
        }

        public Builder forwardingEnabled(Boolean forwardingEnabled) {
            this.forwardingEnabled = Optional.ofNullable(forwardingEnabled);
            return this;
        }

        /**
         * <p>Unix timestamp of last forwarded email received (null if never)</p>
         */
        @JsonSetter(value = "forwarded_email_last_received_at", nulls = Nulls.SKIP)
        public Builder forwardedEmailLastReceivedAt(Optional<Integer> forwardedEmailLastReceivedAt) {
            this.forwardedEmailLastReceivedAt = forwardedEmailLastReceivedAt;
            return this;
        }

        public Builder forwardedEmailLastReceivedAt(Integer forwardedEmailLastReceivedAt) {
            this.forwardedEmailLastReceivedAt = Optional.ofNullable(forwardedEmailLastReceivedAt);
            return this;
        }

        /**
         * <p>Unix timestamp of creation</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>Unix timestamp of last modification</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public EmailSetting build() {
            return new EmailSetting(
                    type,
                    id,
                    email,
                    verified,
                    domain,
                    brandId,
                    forwardingEnabled,
                    forwardedEmailLastReceivedAt,
                    createdAt,
                    updatedAt,
                    additionalProperties);
        }
    }
}
