/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.jobs.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Jobs.Builder.class)
public final class Jobs {
    private final Optional<String> type;

    private final String id;

    private final Optional<String> url;

    private final Optional<Status> status;

    private final Optional<String> resourceType;

    private final Optional<String> resourceId;

    private final Optional<String> resourceUrl;

    private final Map<String, Object> additionalProperties;

    private Jobs(
            Optional<String> type,
            String id,
            Optional<String> url,
            Optional<Status> status,
            Optional<String> resourceType,
            Optional<String> resourceId,
            Optional<String> resourceUrl,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.url = url;
        this.status = status;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.resourceUrl = resourceUrl;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The id of the job that's currently being processed or has completed.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return API endpoint URL to check the job status.
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    /**
     * @return The status of the job execution.
     */
    @JsonProperty("status")
    public Optional<Status> getStatus() {
        return status;
    }

    /**
     * @return The type of resource created during job execution.
     */
    @JsonProperty("resource_type")
    public Optional<String> getResourceType() {
        return resourceType;
    }

    /**
     * @return The id of the resource created during job execution (e.g. ticket id)
     */
    @JsonProperty("resource_id")
    public Optional<String> getResourceId() {
        return resourceId;
    }

    /**
     * @return The url of the resource created during job exeuction. Use this url to fetch the resource.
     */
    @JsonProperty("resource_url")
    public Optional<String> getResourceUrl() {
        return resourceUrl;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Jobs && equalTo((Jobs) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Jobs other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && url.equals(other.url)
                && status.equals(other.status)
                && resourceType.equals(other.resourceType)
                && resourceId.equals(other.resourceId)
                && resourceUrl.equals(other.resourceUrl);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type, this.id, this.url, this.status, this.resourceType, this.resourceId, this.resourceUrl);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The id of the job that's currently being processed or has completed.</p>
         */
        _FinalStage id(@NotNull String id);

        Builder from(Jobs other);
    }

    public interface _FinalStage {
        Jobs build();

        /**
         * <p>The type of the object</p>
         */
        _FinalStage type(Optional<String> type);

        _FinalStage type(String type);

        /**
         * <p>API endpoint URL to check the job status.</p>
         */
        _FinalStage url(Optional<String> url);

        _FinalStage url(String url);

        /**
         * <p>The status of the job execution.</p>
         */
        _FinalStage status(Optional<Status> status);

        _FinalStage status(Status status);

        /**
         * <p>The type of resource created during job execution.</p>
         */
        _FinalStage resourceType(Optional<String> resourceType);

        _FinalStage resourceType(String resourceType);

        /**
         * <p>The id of the resource created during job execution (e.g. ticket id)</p>
         */
        _FinalStage resourceId(Optional<String> resourceId);

        _FinalStage resourceId(String resourceId);

        /**
         * <p>The url of the resource created during job exeuction. Use this url to fetch the resource.</p>
         */
        _FinalStage resourceUrl(Optional<String> resourceUrl);

        _FinalStage resourceUrl(String resourceUrl);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, _FinalStage {
        private String id;

        private Optional<String> resourceUrl = Optional.empty();

        private Optional<String> resourceId = Optional.empty();

        private Optional<String> resourceType = Optional.empty();

        private Optional<Status> status = Optional.empty();

        private Optional<String> url = Optional.empty();

        private Optional<String> type = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Jobs other) {
            type(other.getType());
            id(other.getId());
            url(other.getUrl());
            status(other.getStatus());
            resourceType(other.getResourceType());
            resourceId(other.getResourceId());
            resourceUrl(other.getResourceUrl());
            return this;
        }

        /**
         * <p>The id of the job that's currently being processed or has completed.</p>
         * <p>The id of the job that's currently being processed or has completed.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The url of the resource created during job exeuction. Use this url to fetch the resource.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage resourceUrl(String resourceUrl) {
            this.resourceUrl = Optional.ofNullable(resourceUrl);
            return this;
        }

        /**
         * <p>The url of the resource created during job exeuction. Use this url to fetch the resource.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "resource_url", nulls = Nulls.SKIP)
        public _FinalStage resourceUrl(Optional<String> resourceUrl) {
            this.resourceUrl = resourceUrl;
            return this;
        }

        /**
         * <p>The id of the resource created during job execution (e.g. ticket id)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage resourceId(String resourceId) {
            this.resourceId = Optional.ofNullable(resourceId);
            return this;
        }

        /**
         * <p>The id of the resource created during job execution (e.g. ticket id)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "resource_id", nulls = Nulls.SKIP)
        public _FinalStage resourceId(Optional<String> resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * <p>The type of resource created during job execution.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage resourceType(String resourceType) {
            this.resourceType = Optional.ofNullable(resourceType);
            return this;
        }

        /**
         * <p>The type of resource created during job execution.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "resource_type", nulls = Nulls.SKIP)
        public _FinalStage resourceType(Optional<String> resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * <p>The status of the job execution.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage status(Status status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        /**
         * <p>The status of the job execution.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<Status> status) {
            this.status = status;
            return this;
        }

        /**
         * <p>API endpoint URL to check the job status.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        /**
         * <p>API endpoint URL to check the job status.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        /**
         * <p>The type of the object</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The type of the object</p>
         */
        @java.lang.Override
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @java.lang.Override
        public Jobs build() {
            return new Jobs(type, id, url, status, resourceType, resourceId, resourceUrl, additionalProperties);
        }
    }

    public static final class Status {
        public static final Status SUCCESS = new Status(Value.SUCCESS, "success");

        public static final Status FAILED = new Status(Value.FAILED, "failed");

        public static final Status PENDING = new Status(Value.PENDING, "pending");

        private final Value value;

        private final String string;

        Status(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Status && this.string.equals(((Status) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case SUCCESS:
                    return visitor.visitSuccess();
                case FAILED:
                    return visitor.visitFailed();
                case PENDING:
                    return visitor.visitPending();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Status valueOf(String value) {
            switch (value) {
                case "success":
                    return SUCCESS;
                case "failed":
                    return FAILED;
                case "pending":
                    return PENDING;
                default:
                    return new Status(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            PENDING,

            SUCCESS,

            FAILED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitPending();

            T visitSuccess();

            T visitFailed();

            T visitUnknown(String unknownType);
        }
    }
}
