/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.segments.types.Segment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CompanyAttachedSegments.Builder.class)
public final class CompanyAttachedSegments {
    private final Optional<String> type;

    private final Optional<List<Segment>> data;

    private final Map<String, Object> additionalProperties;

    private CompanyAttachedSegments(
            Optional<String> type, Optional<List<Segment>> data, Map<String, Object> additionalProperties) {
        this.type = type;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object - <code>list</code>
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return An array containing Segment Objects
     */
    @JsonProperty("data")
    public Optional<List<Segment>> getData() {
        return data;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CompanyAttachedSegments && equalTo((CompanyAttachedSegments) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyAttachedSegments other) {
        return type.equals(other.type) && data.equals(other.data);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.data);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Segment>> data = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CompanyAttachedSegments other) {
            type(other.getType());
            data(other.getData());
            return this;
        }

        /**
         * <p>The type of object - <code>list</code></p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>An array containing Segment Objects</p>
         */
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(Optional<List<Segment>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<Segment> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public CompanyAttachedSegments build() {
            return new CompanyAttachedSegments(type, data, additionalProperties);
        }
    }
}
