/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AttachContactToCompanyRequest {
    private final String contactId;
    private final String companyId;
    private final Map<String, Object> additionalProperties;

    private AttachContactToCompanyRequest(String contactId, String companyId, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.companyId = companyId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="contact_id")
    public String getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="id")
    public String getCompanyId() {
        return this.companyId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AttachContactToCompanyRequest && this.equalTo((AttachContactToCompanyRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AttachContactToCompanyRequest other) {
        return this.contactId.equals(other.contactId) && this.companyId.equals(other.companyId);
    }

    public int hashCode() {
        return Objects.hash(this.contactId, this.companyId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ContactIdStage,
    CompanyIdStage,
    _FinalStage {
        private String contactId;
        private String companyId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AttachContactToCompanyRequest other) {
            this.contactId(other.getContactId());
            this.companyId(other.getCompanyId());
            return this;
        }

        @Override
        @JsonSetter(value="contact_id")
        public CompanyIdStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        public AttachContactToCompanyRequest build() {
            return new AttachContactToCompanyRequest(this.contactId, this.companyId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AttachContactToCompanyRequest build();
    }

    public static interface CompanyIdStage {
        public _FinalStage companyId(@NotNull String var1);
    }

    public static interface ContactIdStage {
        public CompanyIdStage contactId(@NotNull String var1);

        public Builder from(AttachContactToCompanyRequest var1);
    }
}

