/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tags;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.tags.RawTagsClient;
import com.intercom.api.resources.tags.requests.DeleteTagRequest;
import com.intercom.api.resources.tags.requests.FindTagRequest;
import com.intercom.api.resources.tags.requests.TagContactRequest;
import com.intercom.api.resources.tags.requests.TagConversationRequest;
import com.intercom.api.resources.tags.requests.TagTicketRequest;
import com.intercom.api.resources.tags.requests.UntagContactRequest;
import com.intercom.api.resources.tags.requests.UntagConversationRequest;
import com.intercom.api.resources.tags.requests.UntagTicketRequest;
import com.intercom.api.resources.tags.types.Tag;
import com.intercom.api.resources.tags.types.TagsCreateRequestBody;
import com.intercom.api.types.TagList;

public class TagsClient {
    protected final ClientOptions clientOptions;
    private final RawTagsClient rawClient;

    public TagsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTagsClient(clientOptions);
    }

    public RawTagsClient withRawResponse() {
        return this.rawClient;
    }

    public Tag tagContact(TagContactRequest request) {
        return this.rawClient.tagContact(request).body();
    }

    public Tag tagContact(TagContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagContact(request, requestOptions).body();
    }

    public Tag untagContact(UntagContactRequest request) {
        return this.rawClient.untagContact(request).body();
    }

    public Tag untagContact(UntagContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagContact(request, requestOptions).body();
    }

    public Tag tagConversation(TagConversationRequest request) {
        return this.rawClient.tagConversation(request).body();
    }

    public Tag tagConversation(TagConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagConversation(request, requestOptions).body();
    }

    public Tag untagConversation(UntagConversationRequest request) {
        return this.rawClient.untagConversation(request).body();
    }

    public Tag untagConversation(UntagConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagConversation(request, requestOptions).body();
    }

    public TagList list() {
        return this.rawClient.list().body();
    }

    public TagList list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    public Tag create(TagsCreateRequestBody request) {
        return this.rawClient.create(request).body();
    }

    public Tag create(TagsCreateRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public Tag find(FindTagRequest request) {
        return this.rawClient.find(request).body();
    }

    public Tag find(FindTagRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    public void delete(DeleteTagRequest request) {
        this.rawClient.delete(request).body();
    }

    public void delete(DeleteTagRequest request, RequestOptions requestOptions) {
        this.rawClient.delete(request, requestOptions).body();
    }

    public Tag tagTicket(TagTicketRequest request) {
        return this.rawClient.tagTicket(request).body();
    }

    public Tag tagTicket(TagTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagTicket(request, requestOptions).body();
    }

    public Tag untagTicket(UntagTicketRequest request) {
        return this.rawClient.untagTicket(request).body();
    }

    public Tag untagTicket(UntagTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagTicket(request, requestOptions).body();
    }
}

