/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.aicontent.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateContentImportSourceRequest {
    private final Optional<Status> status;
    private final String url;
    private final Map<String, Object> additionalProperties;

    private CreateContentImportSourceRequest(Optional<Status> status, String url, Map<String, Object> additionalProperties) {
        this.status = status;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="sync_behavior")
    public String getSyncBehavior() {
        return "api";
    }

    @JsonProperty(value="status")
    public Optional<Status> getStatus() {
        return this.status;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateContentImportSourceRequest && this.equalTo((CreateContentImportSourceRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateContentImportSourceRequest other) {
        return this.status.equals(other.status) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UrlStage builder() {
        return new Builder();
    }

    public static final class Status {
        public static final Status DEACTIVATED = new Status(Value.DEACTIVATED, "deactivated");
        public static final Status ACTIVE = new Status(Value.ACTIVE, "active");
        private final Value value;
        private final String string;

        Status(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Status && this.string.equals(((Status)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case DEACTIVATED: {
                    return visitor.visitDeactivated();
                }
                case ACTIVE: {
                    return visitor.visitActive();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Status valueOf(String value) {
            switch (value) {
                case "deactivated": {
                    return DEACTIVATED;
                }
                case "active": {
                    return ACTIVE;
                }
            }
            return new Status(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitActive();

            public T visitDeactivated();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            ACTIVE,
            DEACTIVATED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UrlStage,
    _FinalStage {
        private String url;
        private Optional<Status> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateContentImportSourceRequest other) {
            this.status(other.getStatus());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        public _FinalStage status(Status status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<Status> status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateContentImportSourceRequest build() {
            return new CreateContentImportSourceRequest(this.status, this.url, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateContentImportSourceRequest build();

        public _FinalStage status(Optional<Status> var1);

        public _FinalStage status(Status var1);
    }

    public static interface UrlStage {
        public _FinalStage url(@NotNull String var1);

        public Builder from(CreateContentImportSourceRequest var1);
    }
}

